/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import java.util.Objects;
import org.eclipse.hono.adapter.ProtocolAdapterProperties;
import org.eclipse.hono.adapter.coap.CoapAdapterOptions;

public class CoapAdapterProperties
extends ProtocolAdapterProperties {
    public static final String DEFAULT_ID_SPLIT_REGEX = "@";
    public static final int DEFAULT_CONNECTOR_THREADS = 2;
    public static final int DEFAULT_COAP_THREADS;
    public static final int DEFAULT_DTLS_THREADS;
    public static final int DEFAULT_DTLS_RETRANSMISSION_TIMEOUT = 2000;
    public static final int DEFAULT_EXCHANGE_LIFETIME = 247000;
    public static final boolean DEFAULT_MESSAGE_OFFLOADING = true;
    public static final int DEFAULT_TIMEOUT_TO_ACK = 500;
    public static final int DEFAULT_BLOCKWISE_STATUS_LIFETIME = 300000;
    private String idSplitRegex = "@";
    private String networkConfig = null;
    private String secureNetworkConfig = null;
    private String insecureNetworkConfig = null;
    private int connectorThreads = DEFAULT_CONNECTOR_THREADS;
    private int coapThreads = DEFAULT_COAP_THREADS;
    private int dtlsThreads = DEFAULT_DTLS_THREADS;
    private int dtlsRetransmissionTimeout = 2000;
    private int exchangeLifetime = 247000;
    private int blockwiseStatusLifetime = 300000;
    private boolean messageOffloadingEnabled = true;
    private int timeoutToAck = 500;

    public CoapAdapterProperties() {
    }

    public CoapAdapterProperties(CoapAdapterOptions options) {
        super(options.adapterOptions());
        this.setCoapThreads(options.coapThreads());
        this.setConnectorThreads(options.connectorThreads());
        this.setDtlsRetransmissionTimeout(options.dtlsRetransmissionTimeout());
        this.setDtlsThreads(options.dtlsThreads());
        this.setExchangeLifetime(options.exchangeLifetime());
        this.setIdSplitRegex(options.idSplitRegex());
        this.insecureNetworkConfig = options.insecureNetworkConfig().orElse(null);
        this.messageOffloadingEnabled = options.messageOffloadingEnabled();
        this.networkConfig = options.networkConfig().orElse(null);
        this.secureNetworkConfig = options.secureNetworkConfig().orElse(null);
        this.setTimeoutToAck(options.timeoutToAck());
    }

    public final String getIdSplitRegex() {
        return this.idSplitRegex;
    }

    public final void setIdSplitRegex(String idSplitRegex) {
        this.idSplitRegex = Objects.requireNonNull(idSplitRegex);
    }

    public final String getNetworkConfig() {
        return this.networkConfig;
    }

    public final void setNetworkConfig(String path) {
        this.networkConfig = Objects.requireNonNull(path);
    }

    public final String getSecureNetworkConfig() {
        return this.secureNetworkConfig;
    }

    public final void setSecureNetworkConfig(String path) {
        this.secureNetworkConfig = Objects.requireNonNull(path);
    }

    public final String getInsecureNetworkConfig() {
        return this.insecureNetworkConfig;
    }

    public final void setInsecureNetworkConfig(String path) {
        this.insecureNetworkConfig = Objects.requireNonNull(path);
    }

    public final int getConnectorThreads() {
        return this.connectorThreads;
    }

    public final void setConnectorThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("connector thread count must be at least 1");
        }
        this.connectorThreads = threads;
    }

    public final int getCoapThreads() {
        return this.coapThreads;
    }

    public final void setCoapThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("protocol thread count must be at least 1");
        }
        this.coapThreads = threads;
    }

    public final int getDtlsThreads() {
        return this.dtlsThreads;
    }

    public final void setDtlsThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("dtls thread count must be at least 1");
        }
        this.dtlsThreads = threads;
    }

    public final int getDtlsRetransmissionTimeout() {
        return this.dtlsRetransmissionTimeout;
    }

    public final void setDtlsRetransmissionTimeout(int dtlsRetransmissionTimeout) {
        if (dtlsRetransmissionTimeout < 1) {
            throw new IllegalArgumentException("dtls retransmission timeout must be at least 1");
        }
        this.dtlsRetransmissionTimeout = dtlsRetransmissionTimeout;
    }

    public final int getExchangeLifetime() {
        return this.exchangeLifetime;
    }

    public final void setExchangeLifetime(int exchangeLifetime) {
        if (exchangeLifetime < 1) {
            throw new IllegalArgumentException("exchange lifetime must be at least 1");
        }
        this.exchangeLifetime = exchangeLifetime;
    }

    public final int getBlockwiseStatusLifetime() {
        return this.blockwiseStatusLifetime;
    }

    public final void setBlockwiseStatusLifetime(int blockwiseStatusLifetime) {
        if (blockwiseStatusLifetime < 1) {
            throw new IllegalArgumentException("blockwise status lifetime must be at least 1");
        }
        this.blockwiseStatusLifetime = blockwiseStatusLifetime;
    }

    public final boolean isMessageOffloadingEnabled() {
        return this.messageOffloadingEnabled;
    }

    public final void setMessageOffloadingEnabled(boolean messageOffloading) {
        this.messageOffloadingEnabled = messageOffloading;
    }

    public final int getTimeoutToAck() {
        return this.timeoutToAck;
    }

    public final void setTimeoutToAck(int timeoutToAck) {
        if (timeoutToAck < -1) {
            throw new IllegalArgumentException("timeout to ack must be at least -1");
        }
        this.timeoutToAck = timeoutToAck;
    }

    static {
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu < 4) {
            DEFAULT_COAP_THREADS = 4;
            DEFAULT_DTLS_THREADS = 4;
        } else {
            DEFAULT_COAP_THREADS = cpu;
            DEFAULT_DTLS_THREADS = cpu;
        }
    }
}

