/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.hono.adapter.coap.AbstractHonoResource;
import org.eclipse.hono.adapter.coap.CoapContext;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandResponseResource
extends AbstractHonoResource {
    private static final Logger LOG = LoggerFactory.getLogger(CommandResponseResource.class);
    private static final String SPAN_NAME_DEFAULT = "/%s/*".formatted("command_response");
    private static final String SPAN_NAME_POST = "/%s/:cmd_req_id".formatted("command_response");
    private static final String SPAN_NAME_PUT = "/%s/:tenant_id/:device_id/:cmd_req_id".formatted("command_response");

    public CommandResponseResource(CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        this("command_response", adapter, tracer, vertx);
    }

    public CommandResponseResource(String resourceName, CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        super(resourceName, adapter, tracer, vertx);
    }

    @Override
    protected String getSpanName(Exchange exchange) {
        switch (exchange.getRequest().getCode()) {
            case POST: {
                return SPAN_NAME_POST;
            }
            case PUT: {
                return SPAN_NAME_PUT;
            }
        }
        return SPAN_NAME_DEFAULT;
    }

    @Override
    public Future<Void> handlePostRequest(CoapContext ctx) {
        return this.uploadCommandResponseMessage(ctx);
    }

    @Override
    public Future<Void> handlePutRequest(CoapContext ctx) {
        return this.uploadCommandResponseMessage(ctx);
    }

    public final Future<Void> uploadCommandResponseMessage(CoapContext context) {
        Objects.requireNonNull(context);
        DeviceUser device = context.getOriginDevice();
        DeviceUser authenticatedDevice = context.getAuthenticatedDevice();
        if (!context.isConfirmable()) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, "command response endpoint supports confirmable request messages only"));
        }
        Buffer payload = context.getPayload();
        String contentType = context.getContentType();
        String commandRequestId = context.getCommandRequestId();
        Integer responseStatus = context.getCommandResponseStatus();
        LOG.debug("processing response to command [tenantId: {}, deviceId: {}, cmd-req-id: {}, status code: {}]", new Object[]{device.getTenantId(), device.getDeviceId(), commandRequestId, responseStatus});
        Span currentSpan = TracingHelper.buildChildSpan((Tracer)this.getTracer(), (SpanContext)context.getTracingContext(), (String)"upload Command response", (String)this.getAdapter().getTypeName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)device.getTenantId()).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)device.getDeviceId()).withTag("hono-cmd-status", (Number)responseStatus).withTag("hono-cmd-req-id", commandRequestId).withTag(TracingHelper.TAG_AUTHENTICATED.getKey(), authenticatedDevice != null).start();
        Future deviceRegistrationTracker = this.getAdapter().getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), (Device)authenticatedDevice, currentSpan.context());
        Future tenantTracker = this.getAdapter().getTenantClient().get(device.getTenantId(), currentSpan.context());
        Optional<CommandResponse> cmdResponse = Optional.ofNullable(CommandResponse.fromRequestId((String)commandRequestId, (String)device.getTenantId(), (String)device.getDeviceId(), (Buffer)payload, (String)contentType, (Integer)responseStatus));
        Future commandResponseTracker = cmdResponse.map(res -> Future.succeededFuture((Object)res)).orElseGet(() -> Future.failedFuture((Throwable)new ClientErrorException(400, String.format("command-request-id [%s] or status code [%s] is missing/invalid", commandRequestId, responseStatus))));
        return CompositeFuture.all((Future)tenantTracker, (Future)commandResponseTracker, (Future)deviceRegistrationTracker).compose(ok -> CompositeFuture.all((Future)this.getAdapter().isAdapterEnabled((TenantObject)tenantTracker.result()), (Future)this.getAdapter().checkMessageLimit((TenantObject)tenantTracker.result(), payload.length(), currentSpan.context())).mapEmpty()).compose(ok -> this.getAdapter().getCommandResponseSender(((CommandResponse)commandResponseTracker.result()).getMessagingType(), (TenantObject)tenantTracker.result()).sendCommandResponse((TenantObject)tenantTracker.result(), (RegistrationAssertion)deviceRegistrationTracker.result(), (CommandResponse)commandResponseTracker.result(), currentSpan.context())).onSuccess(ok -> {
            LOG.trace("forwarded command response [command-request-id: {}] to downstream application", (Object)commandRequestId);
            currentSpan.log("forwarded command response to application");
            this.getAdapter().getMetrics().reportCommand(MetricsTags.Direction.RESPONSE, device.getTenantId(), (TenantObject)tenantTracker.result(), MetricsTags.ProcessingOutcome.FORWARDED, payload.length(), context.getTimer());
            context.respondWithCode(CoAP.ResponseCode.CHANGED);
        }).onFailure(t -> {
            LOG.debug("could not send command response [command-request-id: {}] to application", (Object)commandRequestId, t);
            TracingHelper.logError((Span)currentSpan, (Throwable)t);
            this.getAdapter().getMetrics().reportCommand(MetricsTags.Direction.RESPONSE, device.getTenantId(), (TenantObject)tenantTracker.result(), MetricsTags.ProcessingOutcome.from((Throwable)t), payload.length(), context.getTimer());
        }).onComplete(r -> currentSpan.finish());
    }
}

