/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import java.security.Principal;
import java.util.HashMap;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.hono.auth.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceInfoSupplier
implements ApplicationLevelInfoSupplier {
    public static final String EXT_INFO_KEY_HONO_AUTH_ID = "hono-auth-id";
    public static final String EXT_INFO_KEY_HONO_DEVICE = "hono-device";
    private static final Logger LOG = LoggerFactory.getLogger(DeviceInfoSupplier.class);

    public AdditionalInfo getInfo(Principal clientIdentity, Object customArgument) {
        if (customArgument instanceof AdditionalInfo) {
            AdditionalInfo info = (AdditionalInfo)customArgument;
            String authId = (String)info.get(EXT_INFO_KEY_HONO_AUTH_ID, String.class);
            Device device = (Device)info.get(EXT_INFO_KEY_HONO_DEVICE, Device.class);
            LOG.debug("get additional info auth-id: {}, device: {}@{}", new Object[]{authId, device.getDeviceId(), device.getTenantId()});
            return info;
        }
        LOG.debug("get no additional info");
        return AdditionalInfo.empty();
    }

    public static AdditionalInfo createDeviceInfo(Device device, String authId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(EXT_INFO_KEY_HONO_DEVICE, device);
        result.put(EXT_INFO_KEY_HONO_AUTH_ID, authId);
        return AdditionalInfo.from(result);
    }
}

