/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.hono.client.ServiceInvocationException;

public final class CoapErrorResponse {
    private CoapErrorResponse() {
    }

    public static boolean isTemporaryError(Throwable error) {
        return ServiceInvocationException.extractStatusCode((Throwable)error) == 503;
    }

    public static Response newResponse(Throwable cause, CoAP.ResponseCode fallbackCode) {
        String message = Optional.ofNullable(cause).map(ServiceInvocationException::getErrorMessageForExternalClient).orElse(null);
        CoAP.ResponseCode code = CoapErrorResponse.toCoapCode(cause, fallbackCode);
        Response response = CoapErrorResponse.newResponse(code, message);
        switch (code) {
            case SERVICE_UNAVAILABLE: {
                response.getOptions().setMaxAge(2L);
                break;
            }
        }
        return response;
    }

    public static Response newResponse(CoAP.ResponseCode code, String message) {
        Objects.requireNonNull(code);
        Response response = new Response(code);
        response.setPayload(message);
        response.getOptions().setContentFormat(0);
        return response;
    }

    public static CoAP.ResponseCode toCoapCode(Throwable cause, CoAP.ResponseCode fallbackCode) {
        Objects.requireNonNull(fallbackCode);
        if (ServiceInvocationException.class.isInstance(cause)) {
            int statusCode = ((ServiceInvocationException)cause).getErrorCode();
            int codeClass = statusCode / 100;
            int codeDetail = statusCode % 100;
            if (0 < codeClass && codeClass < 8 && 0 <= codeDetail && codeDetail < 32) {
                try {
                    return CoAP.ResponseCode.valueOf((int)(codeClass << 5 | codeDetail));
                }
                catch (MessageFormatException messageFormatException) {
                    // empty catch block
                }
            }
        }
        return fallbackCode;
    }
}

