/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import java.util.Objects;
import org.eclipse.hono.auth.Device;

public final class RequestDeviceAndAuth {
    private final Device originDevice;
    private final String authId;
    private final Device authenticatedDevice;

    public RequestDeviceAndAuth(Device originDevice, String authId, Device authenticatedDevice) {
        this.originDevice = Objects.requireNonNull(originDevice);
        this.authId = authId;
        this.authenticatedDevice = authenticatedDevice;
    }

    public Device getOriginDevice() {
        return this.originDevice;
    }

    public String getAuthId() {
        return this.authId;
    }

    public Device getAuthenticatedDevice() {
        return this.authenticatedDevice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.originDevice);
        if (this.authenticatedDevice == null) {
            sb.append(", unauthenticated");
        } else if (!this.authenticatedDevice.equals(this.originDevice)) {
            sb.append(", via gateway ").append(this.authenticatedDevice);
        }
        sb.append(']');
        return sb.toString();
    }
}

