/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.DeviceCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSharedKeyDeviceIdentity
implements DeviceCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(PreSharedKeyDeviceIdentity.class);
    private final String authId;
    private final String tenantId;
    private final int hash;

    public PreSharedKeyDeviceIdentity(String tenantId, String authId) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.authId = Objects.requireNonNull(authId);
        this.hash = tenantId.hashCode() + 31 * authId.hashCode();
    }

    public static final PreSharedKeyDeviceIdentity create(String identity, String separateRegex, Span span) {
        if (identity == null) {
            LOG.trace("username must not be null");
            if (span != null) {
                span.log("PSK identity must not be null");
            }
            return null;
        }
        if (separateRegex == null) {
            return new PreSharedKeyDeviceIdentity("DEFAULT_TENANT", identity);
        }
        String[] userComponents = identity.split(separateRegex, 2);
        if (userComponents.length != 2) {
            LOG.trace("username [{}] does not comply with expected pattern [<authId>@<tenantId>]", (Object)identity);
            if (span != null) {
                span.log("PSK identity [" + identity + "] does not comply with expected pattern [<authId>" + separateRegex + "<tenantId>]");
            }
            return null;
        }
        return new PreSharedKeyDeviceIdentity(userComponents[1], userComponents[0]);
    }

    public final String getAuthId() {
        return this.authId;
    }

    public final String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreSharedKeyDeviceIdentity other = (PreSharedKeyDeviceIdentity)obj;
        if (this.authId == null ? other.authId != null : !this.authId.equals(other.authId)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    public String getType() {
        return "psk";
    }
}

