/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.monitoring;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.eclipse.hono.adapter.monitoring.ConnectionEventProducer;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.util.RegistrationAssertion;

public abstract class AbstractMessageSenderConnectionEventProducer
implements ConnectionEventProducer {
    protected AbstractMessageSenderConnectionEventProducer() {
    }

    @Override
    public Future<Void> connected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data, SpanContext spanContext) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "connected", data, spanContext);
    }

    @Override
    public Future<Void> disconnected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data, SpanContext spanContext) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "disconnected", data, spanContext);
    }

    private Future<Void> sendNotificationEvent(ConnectionEventProducer.Context context, Device authenticatedDevice, String protocolAdapter, String remoteId, String cause, JsonObject data, SpanContext spanContext) {
        if (authenticatedDevice == null) {
            return Future.succeededFuture();
        }
        String tenantId = authenticatedDevice.getTenantId();
        String deviceId = authenticatedDevice.getDeviceId();
        return context.getTenantClient().get(tenantId, spanContext).compose(tenant -> {
            JsonObject payload = new JsonObject();
            payload.put("cause", (Object)cause);
            payload.put("remote-id", (Object)remoteId);
            payload.put("source", (Object)protocolAdapter);
            if (data != null) {
                payload.put("data", (Object)data);
            }
            return Optional.ofNullable(context.getMessageSenderClient()).map(client -> client.sendEvent(tenant, new RegistrationAssertion(deviceId), "application/vnd.eclipse-hono-dc-notification+json", payload.toBuffer(), null, spanContext)).orElseGet(Future::succeededFuture);
        });
    }
}

