/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.x509;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;
import org.eclipse.hono.util.IdentityTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDnCredentials
extends AbstractDeviceCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectDnCredentials.class);

    private SubjectDnCredentials(String tenantId, String authId, JsonObject clientContext) {
        super(tenantId, authId, clientContext);
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return SubjectDnCredentials.create(tenantId, subjectDn, new JsonObject());
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn, String authIdTemplate, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(clientContext);
        if (authIdTemplate == null) {
            return SubjectDnCredentials.create(tenantId, subjectDn, clientContext);
        }
        String authId = new IdentityTemplate(authIdTemplate).apply(subjectDn);
        LOG.debug("auth-id-template: [{}], generated-auth-id: [{}]", (Object)authIdTemplate, (Object)authId);
        return new SubjectDnCredentials(tenantId, authId, clientContext);
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(clientContext);
        return SubjectDnCredentials.create(tenantId, new X500Principal(subjectDn), clientContext);
    }

    public static SubjectDnCredentials create(String tenantId, X500Principal subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return SubjectDnCredentials.create(tenantId, subjectDn, new JsonObject());
    }

    public static SubjectDnCredentials create(String tenantId, X500Principal subjectDn, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(clientContext);
        return new SubjectDnCredentials(tenantId, subjectDn.getName("RFC2253"), clientContext);
    }

    @Override
    public String getType() {
        return "x509-cert";
    }
}

