/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.eclipse.hono.adapter.MapperEndpointOptions;

public final class MapperEndpoint {
    private boolean tlsEnabled = true;
    private String host;
    private Integer port;
    private String uri;

    public MapperEndpoint() {
    }

    public MapperEndpoint(MapperEndpointOptions options) {
        this.host = options.host().orElse(null);
        this.port = options.port().orElse(null);
        this.tlsEnabled = options.tlsEnabled();
        options.uri().ifPresent(this::setUri);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Objects.requireNonNull(host);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = Objects.requireNonNull(port);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        Objects.requireNonNull(uri);
        if (!this.isUriValid(uri)) {
            throw new IllegalArgumentException("Invalid mapper URI");
        }
        this.uri = uri;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(Boolean flag) {
        this.tlsEnabled = Objects.requireNonNull(flag);
    }

    public static MapperEndpoint from(String host, int port, String uri, boolean tlsEnabled) {
        MapperEndpoint ep = new MapperEndpoint();
        ep.setHost(host);
        ep.setPort(port);
        ep.setUri(uri);
        ep.setTlsEnabled(tlsEnabled);
        return ep;
    }

    private boolean isUriValid(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

