/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.hono.adapter.auth.device.jwt.JwsValidator;
import org.eclipse.hono.client.ClientErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJwsValidator
implements JwsValidator {
    private static final String EXPECTED_TOKEN_TYPE = "JWT";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwsValidator.class);

    private static JsonObject parseSection(String jws, int section) {
        Objects.requireNonNull(jws);
        if (section < 0 || section > 1) {
            throw new IllegalArgumentException("can only decode sections 0 (header) or 1 (body)");
        }
        String[] jwtSplit = jws.split("\\.", 3);
        if (jwtSplit.length != 3) {
            throw new MalformedJwtException("String is not a valid JWS structure");
        }
        try {
            Buffer p = Buffer.buffer((byte[])Base64.getUrlDecoder().decode(jwtSplit[section]));
            return new JsonObject(p);
        }
        catch (RuntimeException e) {
            throw new MalformedJwtException("Cannot parse JWS payload into JSON object", (Throwable)e);
        }
    }

    public static JsonObject getJwtClaims(String jws) {
        return DefaultJwsValidator.parseSection(jws, 1);
    }

    public static JsonObject getJwtHeader(String jws) {
        return DefaultJwsValidator.parseSection(jws, 0);
    }

    private PublicKey convertPublicKeyByteArrayToPublicKey(JsonObject rawPublicKeySecret) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] encodedPublicKey = rawPublicKeySecret.getBinary("key");
        String alg = rawPublicKeySecret.getString("algorithm");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(encodedPublicKey);
        return KeyFactory.getInstance(alg).generatePublic(keySpecX509);
    }

    private void doExpand(String jws, List<JsonObject> candidateKeys, Duration allowedClockSkew, Promise<Jws<Claims>> resultHandler) {
        SignatureAlgorithm signatureAlgorithmFromToken;
        try {
            JsonObject header = DefaultJwsValidator.getJwtHeader(jws);
            signatureAlgorithmFromToken = Optional.ofNullable(header.getString("alg")).map(SignatureAlgorithm::forName).orElseThrow(() -> new SignatureException("Missing signature algorithm header"));
        }
        catch (JwtException e) {
            resultHandler.fail((Throwable)new ClientErrorException(401, (Throwable)e));
            return;
        }
        Optional claims = candidateKeys.stream().filter(spec -> Optional.ofNullable(spec.getString("algorithm")).map(alg -> signatureAlgorithmFromToken.getFamilyName().startsWith((String)alg)).orElse(false)).flatMap(spec -> {
            try {
                return Stream.of(this.convertPublicKeyByteArrayToPublicKey((JsonObject)spec));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                return Stream.empty();
            }
        }).flatMap(publicKey -> {
            try {
                Jws parsedClaims = Jwts.parserBuilder().setAllowedClockSkewSeconds(allowedClockSkew.toSeconds()).setSigningKeyResolver((SigningKeyResolver)new SigningKeyResolverAdapter((PublicKey)publicKey){
                    final /* synthetic */ PublicKey val$publicKey;
                    {
                        this.val$publicKey = publicKey;
                    }

                    public Key resolveSigningKey(JwsHeader header, Claims claims) {
                        String tokenType = Optional.ofNullable(header.getType()).orElseThrow(() -> new MalformedJwtException("JWT must contain typ header"));
                        if (!tokenType.equalsIgnoreCase(DefaultJwsValidator.EXPECTED_TOKEN_TYPE)) {
                            throw new MalformedJwtException("invalid typ header value [expected: %s, found: %s]".formatted(DefaultJwsValidator.EXPECTED_TOKEN_TYPE, tokenType));
                        }
                        SignatureAlgorithm signatureAlgorithm = Optional.ofNullable(header.getAlgorithm()).map(SignatureAlgorithm::forName).orElseThrow(() -> new MalformedJwtException("JWT must contain alg header"));
                        if (signatureAlgorithm.getFamilyName().startsWith(this.val$publicKey.getAlgorithm())) {
                            return this.val$publicKey;
                        }
                        throw new JwtException("key algorithm does not match JWT header value");
                    }
                }).build().parseClaimsJws(jws);
                return Stream.of(parsedClaims);
            }
            catch (JwtException e) {
                LOG.debug("failed to validate token using key [{}]", publicKey, (Object)e);
                return Stream.empty();
            }
        }).findFirst();
        if (claims.isEmpty()) {
            resultHandler.fail((Throwable)new ClientErrorException(401));
        } else {
            try {
                this.assertAdditionalClaimsPolicy((Jws<Claims>)((Jws)claims.get()), allowedClockSkew);
                resultHandler.complete((Object)((Jws)claims.get()));
            }
            catch (JwtException e) {
                resultHandler.fail((Throwable)new ClientErrorException(401, (Throwable)e));
            }
        }
    }

    @Override
    public Future<Jws<Claims>> expand(String token, List<JsonObject> candidateKeys, Duration allowedClockSkew) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(candidateKeys);
        Objects.requireNonNull(allowedClockSkew);
        Promise result = Promise.promise();
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            this.doExpand(token, candidateKeys, allowedClockSkew, (Promise<Jws<Claims>>)result);
        } else {
            currentContext.executeBlocking(codeHandler -> this.doExpand(token, candidateKeys, allowedClockSkew, (Promise<Jws<Claims>>)codeHandler), true, (Handler)result);
        }
        return result.future();
    }

    private void assertAdditionalClaimsPolicy(Jws<Claims> claims, Duration allowedClockSkew) {
        Instant iat = Optional.ofNullable(((Claims)claims.getBody()).getIssuedAt()).map(Date::toInstant).orElseThrow(() -> new UnsupportedJwtException("JWT must contain iat claim"));
        Instant exp = Optional.ofNullable(((Claims)claims.getBody()).getExpiration()).map(Date::toInstant).orElseThrow(() -> new UnsupportedJwtException("JWT must contain exp claim"));
        Instant latestStartOfValidity = Instant.now().plus(allowedClockSkew);
        int validityPeriodHours = 24;
        Instant endOfValidity = iat.plus(Duration.ofHours(24L)).plus(allowedClockSkew);
        if (iat.isAfter(latestStartOfValidity)) {
            throw new UnsupportedJwtException(String.format("iat must not be later than %s seconds from now", allowedClockSkew.toSeconds()));
        }
        if (!exp.isAfter(iat)) {
            throw new UnsupportedJwtException("exp must be after iat");
        }
        if (exp.isAfter(endOfValidity)) {
            throw new UnsupportedJwtException(String.format("exp must be at most %s hours after iat with a skew of %s seconds", 24, allowedClockSkew.toSeconds()));
        }
    }
}

