/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.hono.util.TenantObject;

public final class LimitedResourceKey {
    private final String tenantId;
    private final BiFunction<String, SpanContext, Future<TenantObject>> tenantInfoSupplier;

    public LimitedResourceKey(String tenantId, BiFunction<String, SpanContext, Future<TenantObject>> tenantInfoSupplier) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.tenantInfoSupplier = Objects.requireNonNull(tenantInfoSupplier);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Future<TenantObject> getTenantInformation(SpanContext tracingContext) {
        return this.tenantInfoSupplier.apply(this.tenantId, tracingContext);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitedResourceKey other = (LimitedResourceKey)obj;
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }
}

