/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;

public class JwtCredentials
extends AbstractDeviceCredentials {
    private String jwt;

    private JwtCredentials(String tenantId, String authId, JsonObject clientContext) {
        super(tenantId, authId, clientContext);
    }

    public static JwtCredentials create(String tenantId, String authId, String password) {
        return JwtCredentials.create(tenantId, authId, password, new JsonObject());
    }

    public static JwtCredentials create(String tenantId, String authId, String jwt, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(jwt);
        Objects.requireNonNull(clientContext);
        JwtCredentials credentials = new JwtCredentials(tenantId, authId, clientContext);
        credentials.jwt = jwt;
        return credentials;
    }

    @Override
    public String getType() {
        return "rpk";
    }

    public final String getJwt() {
        return this.jwt;
    }
}

