/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.opentracing.Tracer;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.adapter.auth.device.jwt.JwtCredentials;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.auth.ExternalJwtAuthTokenValidator;
import org.eclipse.hono.util.CredentialsObject;

public class JwtAuthProvider
extends CredentialsApiAuthProvider<JwtCredentials> {
    final ExternalJwtAuthTokenValidator externalJwtAuthTokenValidator;

    public JwtAuthProvider(CredentialsClient credentialsClient, Tracer tracer) {
        this(credentialsClient, tracer, new ExternalJwtAuthTokenValidator());
    }

    public JwtAuthProvider(CredentialsClient credentialsClient, Tracer tracer, ExternalJwtAuthTokenValidator externalJwtAuthTokenValidator) {
        super(credentialsClient, tracer);
        this.externalJwtAuthTokenValidator = externalJwtAuthTokenValidator;
    }

    @Override
    public JwtCredentials getCredentials(JsonObject authInfo) {
        Objects.requireNonNull(authInfo);
        try {
            String tenantId = authInfo.getString("tenant-id");
            String authId = authInfo.getString("auth-id");
            String jwt = authInfo.getString("password");
            if (tenantId == null || authId == null || jwt == null) {
                return null;
            }
            JsonObject clientContext = authInfo.copy();
            clientContext.remove("tenant-id");
            clientContext.remove("auth-id");
            clientContext.remove("password");
            return JwtCredentials.create(tenantId, authId, jwt, clientContext);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            this.log.warn("Reading authInfo failed", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Future<DeviceUser> doValidateCredentials(JwtCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("not running on vert.x Context"));
        }
        Promise result = Promise.promise();
        currentContext.executeBlocking(blockingCodeHandler -> {
            this.log.debug("validating JWT on vert.x worker thread [{}]", (Object)Thread.currentThread().getName());
            try {
                final Jws<Claims> jws = this.getJws(deviceCredentials, credentialsOnRecord);
                blockingCodeHandler.complete((Object)new DeviceUser(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()){
                    private final Instant expirationTime;
                    {
                        super(arg0, arg1);
                        this.expirationTime = ExternalJwtAuthTokenValidator.getExpirationTime((Instant)((Claims)jws.getBody()).getExpiration().toInstant());
                    }

                    public boolean expired() {
                        return this.expirationTime.isBefore(Instant.now());
                    }
                });
            }
            catch (RuntimeException e) {
                blockingCodeHandler.fail((Throwable)new ClientErrorException(401, (Throwable)e));
            }
        }, false, (Handler)result);
        return result.future();
    }

    private Jws<Claims> getJws(JwtCredentials deviceCredentials, CredentialsObject credentialsOnRecord) throws RuntimeException {
        this.externalJwtAuthTokenValidator.setCredentialsObject(credentialsOnRecord);
        return this.externalJwtAuthTokenValidator.expand(deviceCredentials.getJwt());
    }
}

