/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.util.ExecutionContext;
import org.eclipse.hono.util.QoS;

public interface TelemetryExecutionContext
extends ExecutionContext {
    public Device getAuthenticatedDevice();

    default public boolean isDeviceAuthenticated() {
        return this.getAuthenticatedDevice() != null;
    }

    public QoS getRequestedQos();

    public Optional<Duration> getTimeToLive();

    public String getOrigAddress();

    default public Map<String, Object> getDownstreamMessageProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Optional.ofNullable(this.getOrigAddress()).ifPresent(address -> props.put("orig_address", address));
        this.getTimeToLive().ifPresent(ttl -> props.put("ttl", ttl.getSeconds()));
        return props;
    }
}

