/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.ext.web.client.WebClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.hono.adapter.resourcelimits.LimitedResource;
import org.eclipse.hono.adapter.resourcelimits.LimitedResourceKey;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedAsyncCacheLoader;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection
public class ConnectedDevicesAsyncCacheLoader
extends PrometheusBasedAsyncCacheLoader<LimitedResourceKey, LimitedResource<Long>> {
    private static final String METRIC_NAME_CONNECTIONS = "hono.connections.authenticated".replace(".", "_");
    private static final Logger LOG = LoggerFactory.getLogger(ConnectedDevicesAsyncCacheLoader.class);

    public ConnectedDevicesAsyncCacheLoader(WebClient webClient, PrometheusBasedResourceLimitChecksConfig config, Tracer tracer) {
        super(webClient, config, tracer);
    }

    public CompletableFuture<LimitedResource<Long>> asyncLoad(LimitedResourceKey key, Executor executor) {
        Span span = this.tracer.buildSpan("determine number of connected devices").withTag((Tag)Tags.COMPONENT, (Object)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), key.getTenantId()).start();
        CompletableFuture result = new CompletableFuture();
        key.getTenantInformation(span.context()).onFailure(result::completeExceptionally).onSuccess(tenant -> {
            if (tenant.getResourceLimits() == null) {
                span.log(Map.of("message", "no resource limits configured"));
                LOG.trace("no resource limits configured for tenant [{}]", (Object)tenant.getTenantId());
                result.complete(new LimitedResource<Long>(null, 0L));
            } else {
                long maxConnections = tenant.getResourceLimits().getMaxConnections();
                LOG.trace("connection limit for tenant [{}] is [{}]", (Object)tenant.getTenantId(), (Object)maxConnections);
                if (maxConnections == -1L) {
                    span.log(Map.of("message", "no connection limit configured"));
                    result.complete(new LimitedResource<Long>(null, 0L));
                } else {
                    String queryParams = String.format("sum(%s{tenant=\"%s\"})", METRIC_NAME_CONNECTIONS, key.getTenantId());
                    this.executeQuery(queryParams, span.context()).onSuccess(v -> result.complete(new LimitedResource<Long>(maxConnections, (Long)v))).onFailure(result::completeExceptionally);
                }
            }
        });
        return result.whenComplete((count, error) -> span.finish());
    }
}

