/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.util.MessagingClientProvider;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingClientProviders
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingClientProviders.class);
    private final MessagingClientProvider<TelemetrySender> telemetrySenderProvider;
    private final MessagingClientProvider<EventSender> eventSenderProvider;
    private final MessagingClientProvider<CommandResponseSender> commandResponseSenderProvider;

    public MessagingClientProviders(MessagingClientProvider<TelemetrySender> telemetrySenderProvider, MessagingClientProvider<EventSender> eventSenderProvider, MessagingClientProvider<CommandResponseSender> commandResponseSenderProvider) {
        Objects.requireNonNull(telemetrySenderProvider);
        Objects.requireNonNull(eventSenderProvider);
        Objects.requireNonNull(commandResponseSenderProvider);
        if (!telemetrySenderProvider.containsImplementations()) {
            throw new IllegalArgumentException("at least one TelemetrySender implementation must be set");
        }
        if (!eventSenderProvider.containsImplementations()) {
            throw new IllegalArgumentException("at least one EventSender implementation must be set");
        }
        if (!commandResponseSenderProvider.containsImplementations()) {
            throw new IllegalArgumentException("at least one CommandResponseSender implementation must be set");
        }
        this.telemetrySenderProvider = telemetrySenderProvider;
        this.eventSenderProvider = eventSenderProvider;
        this.commandResponseSenderProvider = commandResponseSenderProvider;
    }

    public EventSender getEventSender(TenantObject tenant) {
        return (EventSender)this.eventSenderProvider.getClient(tenant);
    }

    public TelemetrySender getTelemetrySender(TenantObject tenant) {
        return (TelemetrySender)this.telemetrySenderProvider.getClient(tenant);
    }

    public CommandResponseSender getCommandResponseSender(MessagingType messagingType, TenantObject tenant) {
        return Optional.ofNullable((CommandResponseSender)this.commandResponseSenderProvider.getClient(messagingType)).orElseGet(() -> {
            LOG.info("no command response sender provider set for {} messaging type, using tenant or global default", (Object)messagingType);
            return (CommandResponseSender)this.commandResponseSenderProvider.getClient(tenant);
        });
    }

    public MessagingClientProvider<TelemetrySender> getTelemetrySenderProvider() {
        return this.telemetrySenderProvider;
    }

    public MessagingClientProvider<EventSender> getEventSenderProvider() {
        return this.eventSenderProvider;
    }

    public MessagingClientProvider<CommandResponseSender> getCommandResponseSenderProvider() {
        return this.commandResponseSenderProvider;
    }

    public Future<Void> start() {
        return CompositeFuture.all((Future)this.telemetrySenderProvider.start(), (Future)this.eventSenderProvider.start(), (Future)this.commandResponseSenderProvider.start()).mapEmpty();
    }

    public Future<Void> stop() {
        return CompositeFuture.all((Future)this.telemetrySenderProvider.stop(), (Future)this.eventSenderProvider.stop(), (Future)this.commandResponseSenderProvider.stop()).mapEmpty();
    }

    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.telemetrySenderProvider.registerLivenessChecks(handler);
        this.eventSenderProvider.registerLivenessChecks(handler);
        this.commandResponseSenderProvider.registerLivenessChecks(handler);
    }

    public void registerReadinessChecks(HealthCheckHandler handler) {
        this.telemetrySenderProvider.registerReadinessChecks(handler);
        this.eventSenderProvider.registerReadinessChecks(handler);
        this.commandResponseSenderProvider.registerReadinessChecks(handler);
    }
}

