/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.metric;

import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import org.eclipse.hono.adapter.metric.Metrics;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.TenantObject;

public class NoopBasedMetrics
implements Metrics {
    protected NoopBasedMetrics() {
    }

    @Override
    public void incrementUnauthenticatedConnections() {
    }

    @Override
    public void decrementUnauthenticatedConnections() {
    }

    @Override
    public void incrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
    }

    @Override
    public void decrementConnections(String tenantId) {
        Objects.requireNonNull(tenantId);
    }

    @Override
    public void reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome outcome, String tenantId) {
        Objects.requireNonNull(outcome);
    }

    @Override
    public void reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome outcome, String tenantId, String cipherSuite) {
        Objects.requireNonNull(outcome);
    }

    @Override
    public int getNumberOfConnections() {
        return 0;
    }

    @Override
    public Timer.Sample startTimer() {
        return null;
    }

    @Override
    public void reportTelemetry(MetricsTags.EndpointType type, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, Timer.Sample timer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(qos);
        Objects.requireNonNull(timer);
        if (MetricsTags.EndpointType.TELEMETRY != type && MetricsTags.EndpointType.EVENT != type) {
            throw new IllegalArgumentException("type must be either TELEMETRY or EVENT");
        }
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
    }

    @Override
    public void reportTelemetry(MetricsTags.EndpointType type, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, MetricsTags.QoS qos, int payloadSize, MetricsTags.TtdStatus ttdStatus, Timer.Sample timer) {
        this.reportTelemetry(type, tenantId, tenantObject, outcome, qos, payloadSize, timer);
    }

    @Override
    public void reportCommand(MetricsTags.Direction direction, String tenantId, TenantObject tenantObject, MetricsTags.ProcessingOutcome outcome, int payloadSize, Timer.Sample timer) {
        Objects.requireNonNull(direction);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(timer);
        if (payloadSize < 0) {
            throw new IllegalArgumentException("payload size must not be negative");
        }
    }
}

