/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import org.eclipse.hono.adapter.client.command.CommandResponseSender;
import org.eclipse.hono.adapter.client.telemetry.EventSender;
import org.eclipse.hono.adapter.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.util.MessagingClient;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.TenantObject;

public final class MessagingClients
implements Lifecycle {
    private MessagingClient<TelemetrySender> telemetrySenders;
    private MessagingClient<EventSender> eventSenders;
    private MessagingClient<CommandResponseSender> commandResponseSenders;

    public MessagingClients(MessagingClient<TelemetrySender> telemetrySenders, MessagingClient<EventSender> eventSenders, MessagingClient<CommandResponseSender> commandResponseSenders) {
        Objects.requireNonNull(telemetrySenders);
        Objects.requireNonNull(eventSenders);
        Objects.requireNonNull(commandResponseSenders);
        if (!telemetrySenders.containsImplementations()) {
            throw new IllegalArgumentException("at least one TelemetrySender implementation must be set");
        }
        if (!eventSenders.containsImplementations()) {
            throw new IllegalArgumentException("at least one EventSender implementation must be set");
        }
        if (!commandResponseSenders.containsImplementations()) {
            throw new IllegalArgumentException("at least one CommandResponseSender implementation must be set");
        }
        this.telemetrySenders = telemetrySenders;
        this.eventSenders = eventSenders;
        this.commandResponseSenders = commandResponseSenders;
    }

    public EventSender getEventSender(TenantObject tenant) {
        return (EventSender)this.eventSenders.getClient(tenant);
    }

    public TelemetrySender getTelemetrySender(TenantObject tenant) {
        return (TelemetrySender)this.telemetrySenders.getClient(tenant);
    }

    public CommandResponseSender getCommandResponseSender(TenantObject tenant) {
        return (CommandResponseSender)this.commandResponseSenders.getClient(tenant);
    }

    public Future<Void> start() {
        return CompositeFuture.all((Future)this.telemetrySenders.start(), (Future)this.eventSenders.start(), (Future)this.commandResponseSenders.start()).mapEmpty();
    }

    public Future<Void> stop() {
        return CompositeFuture.all((Future)this.telemetrySenders.stop(), (Future)this.eventSenders.stop(), (Future)this.commandResponseSenders.stop()).mapEmpty();
    }

    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.telemetrySenders.registerLivenessChecks(handler);
        this.eventSenders.registerLivenessChecks(handler);
        this.commandResponseSenders.registerLivenessChecks(handler);
    }

    public void registerReadinessChecks(HealthCheckHandler handler) {
        this.telemetrySenders.registerReadinessChecks(handler);
        this.eventSenders.registerReadinessChecks(handler);
        this.commandResponseSenders.registerReadinessChecks(handler);
    }
}

