/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device;

import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.adapter.auth.device.SubjectDnCredentials;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.util.CredentialsObject;
import org.springframework.beans.factory.annotation.Autowired;

public class X509AuthProvider
extends CredentialsApiAuthProvider<SubjectDnCredentials> {
    @Autowired
    public X509AuthProvider(CredentialsClient credentialsClient, Tracer tracer) {
        super(credentialsClient, tracer);
    }

    @Override
    public SubjectDnCredentials getCredentials(JsonObject authInfo) {
        Objects.requireNonNull(authInfo);
        try {
            String tenantId = authInfo.getString("tenant-id");
            String subjectDn = authInfo.getString("subject-dn");
            String authIdTemplate = authInfo.getString("auth-id-template");
            if (tenantId == null || subjectDn == null) {
                return null;
            }
            JsonObject clientContext = authInfo.copy();
            clientContext.remove("tenant-id");
            clientContext.remove("subject-dn");
            clientContext.remove("auth-id-template");
            return SubjectDnCredentials.create(tenantId, subjectDn, authIdTemplate, clientContext);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            this.log.warn("Reading authInfo failed", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Future<Device> doValidateCredentials(SubjectDnCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        return Future.succeededFuture((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
    }
}

