/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.vertx.ext.web.client.WebClient;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.hono.adapter.resourcelimits.LimitedResource;
import org.eclipse.hono.adapter.resourcelimits.LimitedResourceKey;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedAsyncCacheLoader;
import org.eclipse.hono.adapter.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.DataVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataVolumeAsyncCacheLoader
extends PrometheusBasedAsyncCacheLoader<LimitedResourceKey, LimitedResource<Long>> {
    private static final String METRIC_NAME_COMMANDS_PAYLOAD_SIZE = String.format("%s_bytes_sum", "hono.commands.payload".replace(".", "_"));
    private static final String METRIC_NAME_MESSAGES_PAYLOAD_SIZE = String.format("%s_bytes_sum", "hono.messages.payload".replace(".", "_"));
    private static final String QUERY_TEMPLATE_MESSAGE_LIMIT = String.format("floor(sum(increase(%1$s{status=~\"%3$s|%4$s\", tenant=\"%%1$s\"} [%%2$dm]) or vector(0)) + sum(increase(%2$s{status=~\"%3$s|%4$s\", tenant=\"%%1$s\"} [%%2$dm]) or vector(0)))", METRIC_NAME_MESSAGES_PAYLOAD_SIZE, METRIC_NAME_COMMANDS_PAYLOAD_SIZE, MetricsTags.ProcessingOutcome.FORWARDED.asTag().getValue(), MetricsTags.ProcessingOutcome.UNPROCESSABLE.asTag().getValue());
    private static final Logger LOG = LoggerFactory.getLogger(DataVolumeAsyncCacheLoader.class);

    public DataVolumeAsyncCacheLoader(WebClient webClient, PrometheusBasedResourceLimitChecksConfig config, Tracer tracer) {
        super(webClient, config, tracer);
    }

    public CompletableFuture<LimitedResource<Long>> asyncLoad(LimitedResourceKey key, Executor executor) {
        Span span = this.tracer.buildSpan("determine used data volume").withTag((Tag)Tags.COMPONENT, (Object)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), key.getTenantId()).start();
        CompletableFuture result = new CompletableFuture();
        key.getTenantInformation(span.context()).onFailure(result::completeExceptionally).onSuccess(tenant -> {
            if (tenant.getResourceLimits() == null) {
                span.log(Map.of("message", "no resource limits configured"));
                LOG.trace("no resource limits configured for tenant [{}]", (Object)tenant.getTenantId());
                result.complete(new LimitedResource<Long>(null, 0L));
            } else if (tenant.getResourceLimits().getDataVolume() == null) {
                span.log(Map.of("message", "no message limits configured"));
                LOG.trace("no data volume limits configured for tenant [{}]", (Object)tenant.getTenantId());
                result.complete(new LimitedResource<Long>(null, 0L));
            } else {
                DataVolume dataVolume = tenant.getResourceLimits().getDataVolume();
                LOG.trace("data volume limit config for tenant [{}] are [{}:{}, {}:{}, {}:{}, {}:{}]", new Object[]{tenant.getTenantId(), "max-bytes", dataVolume.getMaxBytes(), "effective-since", dataVolume.getEffectiveSince(), "mode", dataVolume.getPeriod().getMode(), "no-of-days", dataVolume.getPeriod().getNoOfDays()});
                if (dataVolume.isLimited()) {
                    Instant nowUtc = Instant.now(this.clock);
                    Duration dataUsagePeriod = dataVolume.getElapsedAccountingPeriodDuration(nowUtc);
                    Long allowedMaxBytes = this.calculateEffectiveLimit(dataVolume.getEffectiveSince(), nowUtc, dataVolume.getPeriod().getMode(), dataVolume.getMaxBytes());
                    if (dataUsagePeriod.toMinutes() <= 0L) {
                        result.complete(new LimitedResource<Long>(allowedMaxBytes, 0L));
                    } else {
                        String queryParams = String.format(QUERY_TEMPLATE_MESSAGE_LIMIT, key.getTenantId(), dataUsagePeriod.toMinutes());
                        this.executeQuery(queryParams, span.context()).onSuccess(v -> result.complete(new LimitedResource<Long>(allowedMaxBytes, (Long)v))).onFailure(result::completeExceptionally);
                    }
                } else {
                    span.log(Map.of("message", "tenant's data volume is unlimited"));
                    LOG.trace("data volume is unlimited for tenant [{}]", (Object)tenant.getTenantId());
                    result.complete(new LimitedResource<Long>(null, 0L));
                }
            }
        });
        return result.whenComplete((count, error) -> span.finish());
    }
}

