/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.eclipse.hono.adapter.amqp.SaslResponseContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.x509.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.x509.X509Authentication;
import org.eclipse.hono.client.ClientErrorException;

public class SaslExternalAuthHandler
extends ExecutionContextAuthHandler<SaslResponseContext> {
    private final X509Authentication auth;

    public SaslExternalAuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider) {
        this(clientAuth, authProvider, null);
    }

    public SaslExternalAuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider, PreCredentialsValidationHandler<SaslResponseContext> preCredentialsValidationHandler) {
        super(authProvider, preCredentialsValidationHandler);
        this.auth = Objects.requireNonNull(clientAuth);
    }

    public Future<JsonObject> parseCredentials(SaslResponseContext context) {
        Objects.requireNonNull(context);
        Certificate[] peerCertificateChain = context.getPeerCertificateChain();
        if (peerCertificateChain == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(401, "Missing client certificate"));
        }
        if (!(peerCertificateChain[0] instanceof X509Certificate)) {
            return Future.failedFuture((Throwable)new ClientErrorException(401, "Only X.509 certificates are supported"));
        }
        return this.auth.validateClientCertificate(peerCertificateChain, context.getRequestedHostNames(), context.getTracingContext());
    }
}

