/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.amqp.SaslResponseContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.UsernamePasswordCredentials;

public class SaslPlainAuthHandler
extends ExecutionContextAuthHandler<SaslResponseContext> {
    public SaslPlainAuthHandler(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> authProvider) {
        this(authProvider, null);
    }

    public SaslPlainAuthHandler(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> authProvider, PreCredentialsValidationHandler<SaslResponseContext> preCredentialsValidationHandler) {
        super(authProvider, preCredentialsValidationHandler);
    }

    public Future<JsonObject> parseCredentials(SaslResponseContext context) {
        Objects.requireNonNull(context);
        String[] saslResponseFields = context.getSaslResponseFields();
        if (saslResponseFields == null) {
            throw new IllegalArgumentException("no sasl response fields");
        }
        return Future.succeededFuture((Object)new JsonObject().put("username", (Object)saslResponseFields[1]).put("password", (Object)saslResponseFields[2]));
    }
}

