/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import io.micrometer.core.instrument.Timer;
import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonDelivery;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.adapter.MapBasedTelemetryExecutionContext;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;

public class AmqpContext
extends MapBasedTelemetryExecutionContext {
    private ProtonDelivery delivery;
    private Message message;
    private ResourceIdentifier address;
    private Buffer payload;
    private MetricsTags.EndpointType endpoint;
    private Timer.Sample timer;

    private AmqpContext(Span span, Device authenticatedDevice) {
        super(span, authenticatedDevice);
    }

    public static AmqpContext fromMessage(ProtonDelivery delivery, Message message, Span span, Device authenticatedDevice) {
        Objects.requireNonNull(delivery);
        Objects.requireNonNull(message);
        Objects.requireNonNull(span);
        AmqpContext ctx = new AmqpContext(span, authenticatedDevice);
        ctx.delivery = delivery;
        ctx.message = message;
        ctx.payload = AmqpUtils.getPayload((Message)message);
        if (ResourceIdentifier.isValid((String)message.getAddress())) {
            ctx.address = ResourceIdentifier.fromString((String)message.getAddress());
            ctx.endpoint = MetricsTags.EndpointType.fromString((String)ctx.address.getEndpoint());
        }
        return ctx;
    }

    public final Buffer getMessagePayload() {
        return this.payload;
    }

    public final int getPayloadSize() {
        return this.payload == null ? 0 : this.payload.length();
    }

    public final String getMessageContentType() {
        return this.message.getContentType();
    }

    public final Optional<Duration> getTimeToLive() {
        if (this.endpoint == MetricsTags.EndpointType.EVENT && this.message.getTtl() > 0L) {
            return Optional.of(Duration.ofMillis(Math.max(this.message.getTtl(), 1000L)));
        }
        return Optional.empty();
    }

    public final ProtonDelivery delivery() {
        return this.delivery;
    }

    public final Message getMessage() {
        return this.message;
    }

    public final MetricsTags.EndpointType getEndpoint() {
        return this.endpoint;
    }

    public final ResourceIdentifier getAddress() {
        return this.address;
    }

    public final boolean isRemotelySettled() {
        return this.delivery.remotelySettled();
    }

    public final void setTimer(Timer.Sample timer) {
        this.timer = timer;
    }

    public final Timer.Sample getTimer() {
        return this.timer;
    }

    public QoS getRequestedQos() {
        return this.isRemotelySettled() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
    }

    public String getOrigAddress() {
        return this.message.getAddress();
    }
}

