/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.amqp;

import io.opentracing.Span;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.LoginException;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.eclipse.hono.adapter.amqp.AmqpAdapterMetrics;
import org.eclipse.hono.adapter.amqp.SaslExternalAuthHandler;
import org.eclipse.hono.adapter.amqp.SaslPlainAuthHandler;
import org.eclipse.hono.adapter.amqp.SaslResponseContext;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.AuthenticationConstants;
import org.eclipse.hono.util.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAdapterSaslAuthenticatorFactory
implements ProtonSaslAuthenticatorFactory {
    private final AmqpAdapterMetrics metrics;
    private final Supplier<Span> spanFactory;
    private final SaslPlainAuthHandler saslPlainAuthHandler;
    private final SaslExternalAuthHandler saslExternalAuthHandler;

    public AmqpAdapterSaslAuthenticatorFactory(AmqpAdapterMetrics metrics, Supplier<Span> spanFactory, SaslPlainAuthHandler saslPlainAuthHandler, SaslExternalAuthHandler saslExternalAuthHandler) {
        this.metrics = Objects.requireNonNull(metrics);
        this.spanFactory = Objects.requireNonNull(spanFactory);
        this.saslPlainAuthHandler = saslPlainAuthHandler;
        this.saslExternalAuthHandler = saslExternalAuthHandler;
    }

    public ProtonSaslAuthenticator create() {
        return new AmqpAdapterSaslAuthenticator(this.spanFactory.get());
    }

    final class AmqpAdapterSaslAuthenticator
    implements ProtonSaslAuthenticator {
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private final Span currentSpan;
        private Sasl sasl;
        private boolean succeeded;
        private ProtonConnection protonConnection;
        private SSLSession sslSession;

        AmqpAdapterSaslAuthenticator(Span currentSpan) {
            this.currentSpan = currentSpan;
        }

        private String[] getSupportedMechanisms() {
            ArrayList<String> mechanisms = new ArrayList<String>(2);
            if (AmqpAdapterSaslAuthenticatorFactory.this.saslPlainAuthHandler != null) {
                mechanisms.add("PLAIN");
            }
            if (AmqpAdapterSaslAuthenticatorFactory.this.saslExternalAuthHandler != null) {
                mechanisms.add("EXTERNAL");
            }
            return (String[])mechanisms.toArray(String[]::new);
        }

        public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
            this.LOG.trace("initializing SASL authenticator");
            this.protonConnection = protonConnection;
            this.sasl = transport.sasl();
            this.sasl.server();
            this.sasl.allowSkip(false);
            this.sasl.setMechanisms(this.getSupportedMechanisms());
            if (socket.isSsl()) {
                this.LOG.trace("client connected through a secured port");
                this.sslSession = socket.sslSession();
            }
        }

        public void process(Handler<Boolean> completionHandler) {
            String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
            if (remoteMechanisms.length == 0) {
                this.LOG.trace("client device provided an empty list of SASL mechanisms [hostname: {}, state: {}]", (Object)this.sasl.getHostname(), (Object)this.sasl.getState());
                completionHandler.handle((Object)Boolean.FALSE);
                return;
            }
            String remoteMechanism = remoteMechanisms[0];
            this.LOG.debug("client device wants to authenticate using SASL [mechanism: {}, host: {}, state: {}]", new Object[]{remoteMechanism, this.sasl.getHostname(), this.sasl.getState()});
            Context currentContext = Vertx.currentContext();
            byte[] saslResponse = new byte[this.sasl.pending()];
            this.sasl.recv(saslResponse, 0, saslResponse.length);
            String cipherSuite = Optional.ofNullable(this.sslSession).map(SSLSession::getCipherSuite).orElse(null);
            this.buildSaslResponseContext(remoteMechanism, saslResponse).compose(saslResponseContext -> this.verify((SaslResponseContext)((Object)saslResponseContext))).onSuccess(deviceUser -> {
                this.currentSpan.log("credentials verified successfully");
                this.protonConnection.attachments().set((Object)"CURRENT_SPAN", Span.class, (Object)this.currentSpan);
                this.protonConnection.attachments().set((Object)"CLIENT_DEVICE", Device.class, deviceUser);
                Optional.ofNullable(cipherSuite).ifPresent(s -> this.protonConnection.attachments().set((Object)"TLS_CIPHER_SUITE", String.class, s));
                this.succeeded = true;
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
            }).onFailure(t -> {
                String tenantId;
                TracingHelper.logError((Span)this.currentSpan, (Throwable)t);
                this.currentSpan.finish();
                this.LOG.debug("SASL handshake or early stage checks failed", t);
                String string = tenantId = t instanceof ClientErrorException ? ((ClientErrorException)t).getTenant() : null;
                if (t instanceof ClientErrorException || t instanceof LoginException) {
                    AmqpAdapterSaslAuthenticatorFactory.this.metrics.reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome.UNAUTHORIZED, tenantId, cipherSuite);
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                } else {
                    AmqpAdapterSaslAuthenticatorFactory.this.metrics.reportConnectionAttempt(MetricsTags.ConnectionAttemptOutcome.UNAVAILABLE, null, cipherSuite);
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_TEMP);
                }
            }).onComplete(outcome -> {
                if (currentContext == null) {
                    completionHandler.handle((Object)Boolean.TRUE);
                } else {
                    currentContext.runOnContext(action -> completionHandler.handle((Object)Boolean.TRUE));
                }
            });
        }

        private Future<SaslResponseContext> buildSaslResponseContext(String remoteMechanism, byte[] saslResponse) {
            if ("PLAIN".equals(remoteMechanism)) {
                return this.parseSaslResponse(saslResponse).map(fields -> SaslResponseContext.forMechanismPlain(this.protonConnection, fields, this.currentSpan, this.sslSession));
            }
            if ("EXTERNAL".equals(remoteMechanism)) {
                try {
                    return Future.succeededFuture((Object)((Object)SaslResponseContext.forMechanismExternal(this.protonConnection, this.currentSpan, this.sslSession)));
                }
                catch (SSLPeerUnverifiedException e) {
                    this.LOG.debug("device's certificate chain cannot be read: {}", (Object)e.getMessage());
                    return Future.failedFuture((Throwable)e);
                }
            }
            return Future.failedFuture((String)("Unsupported SASL mechanism: " + remoteMechanism));
        }

        private Future<String[]> parseSaslResponse(byte[] saslResponse) {
            try {
                return Future.succeededFuture((Object)AuthenticationConstants.parseSaslResponse((byte[])saslResponse));
            }
            catch (CredentialException e) {
                TracingHelper.logError((Span)this.currentSpan, (Throwable)e);
                return Future.failedFuture((Throwable)e);
            }
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        private Future<DeviceUser> verify(SaslResponseContext ctx) {
            if ("PLAIN".equals(ctx.getRemoteMechanism())) {
                this.currentSpan.log("authenticating device using SASL PLAIN");
                return AmqpAdapterSaslAuthenticatorFactory.this.saslPlainAuthHandler.authenticateDevice((ExecutionContext)ctx);
            }
            if ("EXTERNAL".equals(ctx.getRemoteMechanism())) {
                this.currentSpan.log("authenticating device using SASL EXTERNAL");
                return AmqpAdapterSaslAuthenticatorFactory.this.saslExternalAuthHandler.authenticateDevice((ExecutionContext)ctx);
            }
            return Future.failedFuture((Throwable)new ClientErrorException(400, "Unsupported SASL mechanism: " + ctx.getRemoteMechanism()));
        }
    }
}

