/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.deviceconnection.infinispan.client.InfinispanRemoteConfigurationOptions;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;

public class InfinispanRemoteConfigurationProperties
extends ConfigurationProperties {
    private static final String DEFAULT_EXECUTOR_FACTORY_PREFIX = "infinispan.client.hotrod.default_executor_factory";
    private static final String CONNECTION_POOL_PREFIX = "infinispan.client.hotrod.connection_pool";

    public InfinispanRemoteConfigurationProperties() {
    }

    public InfinispanRemoteConfigurationProperties(InfinispanRemoteConfigurationOptions options) {
        options.authPassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthPassword(arg_0));
        options.authRealm().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthRealm(arg_0));
        options.authServerName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthServerName(arg_0));
        options.authUsername().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthUsername(arg_0));
        this.setCluster(options.cluster());
        this.setConnectionPool(options.connectionPool());
        this.setConnectTimeout(options.connectTimeout());
        this.setDefaultExecutorFactory(options.defaultExecutorFactory());
        options.keyAlias().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyAlias(arg_0));
        options.keyStoreCertificatePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreCertificatePassword(arg_0));
        options.keyStoreFileName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreFileName(arg_0));
        options.keyStorePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStorePassword(arg_0));
        options.keyStoreType().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreType(arg_0));
        options.saslMechanism().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setSaslMechanism(arg_0));
        this.setSaslProperties(options.saslProperties());
        options.serverList().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setServerList(arg_0));
        this.setSocketTimeout(options.socketTimeout());
        options.trustStoreFileName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStoreFileName(arg_0));
        options.trustStorePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStorePassword(arg_0));
        options.trustStorePath().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStorePath(arg_0));
        options.trustStoreType().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStoreType(arg_0));
        this.setUseSSL(options.useSsl());
        options.sslCiphers().ifPresent(this::setSSLCiphers);
        options.sslProtocol().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setSSLProtocol(arg_0));
    }

    public final ConfigurationBuilder getConfigurationBuilder() {
        return new ConfigurationBuilder().withProperties(this.getProperties());
    }

    public final void setConnectionPool(Map<String, String> poolProperties) {
        this.setProperties(poolProperties, CONNECTION_POOL_PREFIX, this::toSnakeCase);
    }

    public final void setDefaultExecutorFactory(Map<String, String> factoryProperties) {
        this.setProperties(factoryProperties, DEFAULT_EXECUTOR_FACTORY_PREFIX, this::toSnakeCase);
    }

    public final void setSaslProperties(Map<String, String> saslProperties) {
        this.setProperties(saslProperties, "infinispan.client.hotrod.sasl_properties", null);
    }

    public final void setCluster(Map<String, String> clusterProperties) {
        this.setProperties(clusterProperties, "infinispan.client.hotrod.cluster", null);
    }

    private String toSnakeCase(String key) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, key);
    }

    private void setProperties(Map<String, String> properties, String keyPrefix, Function<String, String> keyConverter) {
        properties.forEach((k, v) -> {
            String keySuffix = Optional.ofNullable(keyConverter).map(f -> (String)f.apply(k)).orElse((String)k);
            String key = String.format("%s.%s", keyPrefix, keySuffix);
            this.getProperties().setProperty(key, (String)v);
        });
    }

    public String getKeyStoreCertificatePassword() {
        return this.getProperties().getProperty("infinispan.client.hotrod.key_store_certificate_password");
    }

    public String getSSLCiphers() {
        return this.getProperties().getProperty("infinispan.client.hotrod.ssl_ciphers");
    }

    public void setSSLCiphers(String ciphers) {
        this.getProperties().put("infinispan.client.hotrod.ssl_ciphers", ciphers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("serverList", (Object)this.getServerList()).add("authUsername", (Object)this.getAuthUsername()).toString();
    }
}

