/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.deviceconnection.infinispan.client.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCache<K, V>
extends BasicCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedCache.class);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final EmbeddedCacheManager cacheManager;
    private final String cacheName;

    public EmbeddedCache(Vertx vertx, EmbeddedCacheManager cacheManager, String cacheName) {
        super(vertx, (BasicCacheContainer)cacheManager);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheName = Objects.requireNonNull(cacheName);
    }

    @Override
    protected boolean isStarted() {
        return this.cacheManager.isRunning(this.cacheName) && this.getCache() != null;
    }

    @Override
    protected Future<Void> connectToCache() {
        Promise result = Promise.promise();
        if (this.connecting.compareAndSet(false, true)) {
            this.vertx.executeBlocking(r -> {
                try {
                    LOG.debug("trying to start cache manager");
                    this.cacheManager.start();
                    LOG.info("started cache manager");
                    LOG.debug("trying to get cache");
                    this.setCache(this.cacheManager.getCache(this.cacheName));
                    if (this.isStarted()) {
                        r.complete(this.getCache());
                    } else {
                        r.fail((Throwable)new IllegalStateException("cache [" + this.cacheName + "] is not configured"));
                    }
                }
                catch (Exception e) {
                    r.fail((Throwable)e);
                }
            }, attempt -> {
                if (attempt.succeeded()) {
                    LOG.info("successfully connected to cache");
                    result.complete();
                } else {
                    LOG.debug("failed to connect to cache: {}", (Object)attempt.cause().getMessage());
                    result.fail(attempt.cause());
                }
                this.connecting.set(false);
            });
        } else {
            LOG.info("already trying to establish connection to cache");
            result.fail("already trying to establish connection to cache");
        }
        return result.future();
    }

    @Override
    public Future<JsonObject> checkForCacheAvailability() {
        if (this.isStarted()) {
            return Future.succeededFuture((Object)new JsonObject());
        }
        this.connectToCache();
        return Future.failedFuture((String)"not connected to cache");
    }
}

