/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.deviceconnection.infinispan.client.Cache;
import org.eclipse.hono.util.Futures;
import org.eclipse.hono.util.Lifecycle;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCache<K, V>
implements Cache<K, V>,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCache.class);
    protected final Vertx vertx;
    private final BasicCacheContainer cacheManager;
    private org.infinispan.commons.api.BasicCache<K, V> cache;

    public BasicCache(Vertx vertx, BasicCacheContainer cacheManager) {
        this.vertx = Objects.requireNonNull(vertx);
        this.cacheManager = Objects.requireNonNull(cacheManager);
    }

    protected abstract Future<Void> connectToCache();

    protected abstract boolean isStarted();

    public Future<Void> start() {
        return this.connectToCache();
    }

    public Future<Void> stop() {
        Promise result = Promise.promise();
        this.vertx.executeBlocking(r -> {
            try {
                this.cacheManager.stop();
                r.complete();
            }
            catch (Throwable t) {
                r.fail(t);
            }
        }, stopAttempt -> {
            if (stopAttempt.succeeded()) {
                LOG.info("connection(s) to cache stopped successfully");
            } else {
                LOG.info("error trying to stop connection(s) to cache", stopAttempt.cause());
            }
            result.handle(stopAttempt);
        });
        return result.future();
    }

    protected void setCache(org.infinispan.commons.api.BasicCache<K, V> cache) {
        this.cache = cache;
    }

    protected org.infinispan.commons.api.BasicCache<K, V> getCache() {
        return this.cache;
    }

    protected final <T> Future<T> withCache(Function<org.infinispan.commons.api.BasicCache<K, V>, CompletionStage<T>> futureSupplier) {
        org.infinispan.commons.api.BasicCache cache = this.cache;
        return Optional.ofNullable(cache).map(c -> Futures.create(() -> (CompletionStage)futureSupplier.apply(cache))).orElseGet(BasicCache::noConnectionFailure).onComplete(this::postCacheAccess);
    }

    protected <T> void postCacheAccess(AsyncResult<T> cacheOperationResult) {
    }

    @Override
    public Future<V> put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(cache -> cache.putAsync(key, value));
    }

    @Override
    public Future<V> put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(lifespanUnit);
        return this.withCache(cache -> cache.putAsync(key, value, lifespan, lifespanUnit));
    }

    @Override
    public Future<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(cache -> cache.removeAsync(key, value));
    }

    @Override
    public Future<V> get(K key) {
        Objects.requireNonNull(key);
        return this.withCache(cache -> cache.getAsync(key));
    }

    @Override
    public Future<Map<K, V>> getAll(Set<? extends K> keys) {
        Objects.requireNonNull(keys);
        return this.withCache(cache -> cache.getAllAsync(keys));
    }

    protected static <V> Future<V> noConnectionFailure() {
        return Future.failedFuture((Throwable)new ServerErrorException(503, "no connection to data grid"));
    }
}

