/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.deviceconnection.infinispan.client.Cache;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.service.HealthCheckProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheBasedDeviceConnectionInfo
implements DeviceConnectionInfo,
HealthCheckProvider {
    static final Duration LAST_KNOWN_GATEWAY_CACHE_ENTRY_LIFESPAN = Duration.ofDays(28L);
    static final int VIA_GATEWAYS_OPTIMIZATION_THRESHOLD = 3;
    private static final Logger LOG = LoggerFactory.getLogger(CacheBasedDeviceConnectionInfo.class);
    private static final String KEY_PREFIX_GATEWAY_ENTRIES_VALUE = "gw";
    private static final String KEY_PREFIX_ADAPTER_INSTANCE_VALUES = "ai";
    private static final String KEY_SEPARATOR = "@@";
    final Cache<String, String> cache;
    final Tracer tracer;

    public CacheBasedDeviceConnectionInfo(Cache<String, String> cache, Tracer tracer) {
        this.cache = Objects.requireNonNull(cache);
        this.tracer = Objects.requireNonNull(tracer);
    }

    @Override
    public Future<Void> setLastKnownGatewayForDevice(String tenantId, String deviceId, String gatewayId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(span);
        long lifespanMillis = LAST_KNOWN_GATEWAY_CACHE_ENTRY_LIFESPAN.toMillis();
        return this.cache.put(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId), gatewayId, lifespanMillis, TimeUnit.MILLISECONDS).map(replacedValue -> {
            LOG.debug("set last known gateway [tenant: {}, device-id: {}, gateway: {}]", new Object[]{tenantId, deviceId, gatewayId});
            return null;
        }).recover(t -> {
            LOG.debug("failed to set last known gateway [tenant: {}, device-id: {}, gateway: {}]", new Object[]{tenantId, deviceId, gatewayId, t});
            return Future.failedFuture((Throwable)new ServerErrorException(500, t));
        });
    }

    @Override
    public Future<JsonObject> getLastKnownGatewayForDevice(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).recover(t -> {
            LOG.debug("failed to find last known gateway for device [tenant: {}, device-id: {}]", new Object[]{tenantId, deviceId, t});
            return Future.failedFuture((Throwable)new ServerErrorException(500, t));
        }).compose(gatewayId -> {
            if (gatewayId == null) {
                LOG.debug("could not find last known gateway for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                return Future.failedFuture((Throwable)new ClientErrorException(404));
            }
            LOG.debug("found last known gateway for device [tenant: {}, device-id: {}]: {}", new Object[]{tenantId, deviceId, gatewayId});
            return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getLastKnownGatewayResultJson(gatewayId));
        });
    }

    @Override
    public Future<Void> setCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        Objects.requireNonNull(span);
        long lifespanMillis = lifespan == null || lifespan.isNegative() || lifespan.getSeconds() > 9223372036854775L ? -1L : lifespan.toMillis();
        return this.cache.put(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId), adapterInstanceId, lifespanMillis, TimeUnit.MILLISECONDS).map(replacedValue -> {
            LOG.debug("set command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}, lifespan: {}ms]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespanMillis});
            return null;
        }).recover(t -> {
            LOG.debug("failed to set command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}, lifespan: {}ms]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespanMillis, t});
            return Future.failedFuture((Throwable)new ServerErrorException(500, t));
        });
    }

    @Override
    public Future<Boolean> removeCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        Objects.requireNonNull(span);
        String key = CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId);
        return this.cache.remove(key, adapterInstanceId).recover(t -> {
            LOG.debug("failed to remove the cache entry when for the command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId, t});
            return Future.failedFuture((Throwable)new ServerErrorException(500, t));
        }).map(removed -> {
            if (!removed.booleanValue()) {
                LOG.debug("command handling adapter instance was not removed, key not mapped or value didn't match [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            } else {
                LOG.debug("removed command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            }
            return removed;
        });
    }

    @Override
    public Future<JsonObject> getCommandHandlingAdapterInstances(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(viaGateways);
        Objects.requireNonNull(span);
        Object resultFuture = viaGateways.isEmpty() ? this.cache.get(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(adapterInstanceId -> {
            if (adapterInstanceId == null) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                return Future.failedFuture((Throwable)new ClientErrorException(404));
            }
            LOG.debug("found command handling adapter instance '{}' [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId});
            span.log("returning command handling adapter instance for device itself");
            this.setTagsForSingleResult(span, (String)adapterInstanceId);
            return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceId, adapterInstanceId));
        }) : (viaGateways.size() <= 3 ? this.getInstancesQueryingAllGatewaysFirst(tenantId, deviceId, viaGateways, span) : this.getInstancesGettingLastKnownGatewayFirst(tenantId, deviceId, viaGateways, span));
        return resultFuture;
    }

    private Future<JsonObject> getInstancesQueryingAllGatewaysFirst(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, viaGateways)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(getAllMap -> {
            Future resultFuture;
            Map<String, String> deviceToInstanceMap = CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap);
            if (deviceToInstanceMap.isEmpty()) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no command handling adapter instances found");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(404));
            } else if (deviceToInstanceMap.containsKey(deviceId)) {
                resultFuture = this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, deviceToInstanceMap.get(deviceId), span);
            } else if (deviceToInstanceMap.size() > 1) {
                resultFuture = this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(lastKnownGateway -> {
                    if (lastKnownGateway == null) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (no last known gateway found) [tenant: {}, device-id: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId});
                        span.log("no last known gateway found, returning all matching adapter instances");
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    if (!viaGateways.contains(lastKnownGateway)) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (last known gateway not valid anymore) [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId, lastKnownGateway});
                        span.log("last known gateway '" + lastKnownGateway + "' is not valid anymore, returning all matching adapter instances");
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    if (!deviceToInstanceMap.containsKey(lastKnownGateway)) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (last known gateway not in that list) [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId, lastKnownGateway});
                        span.log("last known gateway '" + lastKnownGateway + "' has no adapter instance assigned, returning all matching adapter instances");
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    LOG.debug("returning command handling adapter instance '{}' for last known gateway [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.get(lastKnownGateway), tenantId, deviceId, lastKnownGateway});
                    span.log("returning adapter instance for last known gateway '" + lastKnownGateway + "'");
                    this.setTagsForSingleResultWithGateway(span, (String)deviceToInstanceMap.get(lastKnownGateway), (String)lastKnownGateway);
                    return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(lastKnownGateway, (String)deviceToInstanceMap.get(lastKnownGateway)));
                });
            } else {
                Map.Entry<String, String> foundEntry = deviceToInstanceMap.entrySet().iterator().next();
                LOG.debug("returning command handling adapter instance '{}' associated with gateway {} [tenant: {}, device-id: {}]", new Object[]{foundEntry.getValue(), foundEntry.getKey(), tenantId, deviceId});
                span.log("returning adapter instance associated with gateway '" + foundEntry.getKey() + "'");
                this.setTagsForSingleResultWithGateway(span, foundEntry.getValue(), foundEntry.getKey());
                resultFuture = Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(foundEntry.getKey(), foundEntry.getValue()));
            }
            return resultFuture;
        });
    }

    private void setTagsForSingleResultWithGateway(Span span, String adapterInstanceId, String gatewayId) {
        span.setTag("adapter_instance_id", adapterInstanceId);
        span.setTag("gateway_id", gatewayId);
    }

    private void setTagsForSingleResult(Span span, String adapterInstanceId) {
        span.setTag("adapter_instance_id", adapterInstanceId);
    }

    private Future<JsonObject> getInstancesGettingLastKnownGatewayFirst(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        return this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(lastKnownGateway -> {
            if (lastKnownGateway == null) {
                LOG.trace("no last known gateway found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no last known gateway found");
            } else if (!viaGateways.contains(lastKnownGateway)) {
                LOG.trace("found gateway is not valid for the device anymore [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("found gateway '" + lastKnownGateway + "' is not valid anymore");
            }
            if (lastKnownGateway != null && viaGateways.contains(lastKnownGateway)) {
                return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, lastKnownGateway)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(getAllMap -> {
                    Map<String, String> deviceToInstanceMap = CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap);
                    if (deviceToInstanceMap.isEmpty()) {
                        span.log("last known gateway '" + lastKnownGateway + "' has no adapter instance assigned, returning all matching adapter instances");
                        return this.getAdapterInstancesWithoutLastKnownGatewayCheck(tenantId, deviceId, viaGateways, span);
                    }
                    if (deviceToInstanceMap.containsKey(deviceId)) {
                        return this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, deviceToInstanceMap.get(deviceId), span);
                    }
                    LOG.debug("returning command handling adapter instance '{}' for last known gateway [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.get(lastKnownGateway), tenantId, deviceId, lastKnownGateway});
                    span.log("returning adapter instance for last known gateway '" + lastKnownGateway + "'");
                    this.setTagsForSingleResultWithGateway(span, deviceToInstanceMap.get(lastKnownGateway), (String)lastKnownGateway);
                    return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                });
            }
            return this.getAdapterInstancesWithoutLastKnownGatewayCheck(tenantId, deviceId, viaGateways, span);
        });
    }

    private Future<JsonObject> getAdapterInstancesWithoutLastKnownGatewayCheck(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, viaGateways)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t)).compose(getAllMap -> {
            Future resultFuture;
            Map<String, String> deviceToInstanceMap = CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap);
            if (deviceToInstanceMap.isEmpty()) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(404));
            } else if (deviceToInstanceMap.containsKey(deviceId)) {
                resultFuture = this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, deviceToInstanceMap.get(deviceId), span);
            } else {
                LOG.debug("returning {} command handling adapter instance(s) (no last known gateway found) [tenant: {}, device-id: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId});
                resultFuture = Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
            }
            return resultFuture;
        });
    }

    private Future<JsonObject> getAdapterInstanceFoundForDeviceItselfResult(String tenantId, String deviceId, String adapterInstanceId, Span span) {
        LOG.debug("returning command handling adapter instance '{}' for device itself [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId});
        span.log("returning command handling adapter instance for device itself");
        this.setTagsForSingleResult(span, adapterInstanceId);
        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceId, adapterInstanceId));
    }

    private <T> Future<T> failedToGetEntriesWhenGettingInstances(String tenantId, String deviceId, Throwable t) {
        LOG.debug("failed to get cache entries when trying to get command handling adapter instances [tenant: {}, device-id: {}]", new Object[]{tenantId, deviceId, t});
        return Future.failedFuture((Throwable)new ServerErrorException(500, t));
    }

    private static String getGatewayEntryKey(String tenantId, String deviceId) {
        return "gw@@" + tenantId + KEY_SEPARATOR + deviceId;
    }

    private static String getAdapterInstanceEntryKey(String tenantId, String deviceId) {
        return "ai@@" + tenantId + KEY_SEPARATOR + deviceId;
    }

    private static Set<String> getAdapterInstanceEntryKeys(String tenantId, String deviceIdA, String deviceIdB) {
        HashSet<String> keys = new HashSet<String>(2);
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdA));
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdB));
        return keys;
    }

    private static Map<String, String> convertAdapterInstanceEntryKeys(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> CacheBasedDeviceConnectionInfo.getDeviceIdFromAdapterInstanceEntryKey((String)entry.getKey()), Map.Entry::getValue));
    }

    private static String getDeviceIdFromAdapterInstanceEntryKey(String key) {
        int pos = key.lastIndexOf(KEY_SEPARATOR);
        return key.substring(pos + KEY_SEPARATOR.length());
    }

    private static Set<String> getAdapterInstanceEntryKeys(String tenantId, String deviceIdA, Set<String> additionalDeviceIds) {
        HashSet<String> keys = new HashSet<String>(additionalDeviceIds.size() + 1);
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdA));
        additionalDeviceIds.forEach(id -> keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, id)));
        return keys;
    }

    private static JsonObject getLastKnownGatewayResultJson(String gatewayId) {
        return new JsonObject().put("gateway-id", gatewayId);
    }

    private static JsonObject getAdapterInstancesResultJson(Map<String, String> deviceToAdapterInstanceMap) {
        JsonObject jsonObject = new JsonObject();
        JsonArray adapterInstancesArray = new JsonArray(new ArrayList(deviceToAdapterInstanceMap.size()));
        for (Map.Entry<String, String> resultEntry : deviceToAdapterInstanceMap.entrySet()) {
            JsonObject entryJson = new JsonObject();
            entryJson.put("device-id", resultEntry.getKey());
            entryJson.put("adapter-instance-id", resultEntry.getValue());
            adapterInstancesArray.add(entryJson);
        }
        jsonObject.put("adapter-instances", adapterInstancesArray);
        return jsonObject;
    }

    private static JsonObject getAdapterInstancesResultJson(String deviceId, String adapterInstanceId) {
        return CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(Map.of(deviceId, adapterInstanceId));
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("remote-cache-connection", 1000L, this::checkForCacheAvailability);
    }

    private void checkForCacheAvailability(Promise<Status> status) {
        this.cache.checkForCacheAvailability().map(Status::OK).otherwise(t -> Status.KO()).onComplete(ar -> status.tryComplete((Object)((Status)ar.result())));
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }
}

