/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.SpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.DeviceConnectionClient;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;

public final class CacheBasedDeviceConnectionClient
implements DeviceConnectionClient {
    final String tenantId;
    final DeviceConnectionInfo cache;

    public CacheBasedDeviceConnectionClient(String tenantId, DeviceConnectionInfo cache) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.cache = Objects.requireNonNull(cache);
    }

    public void close(Handler<AsyncResult<Void>> closeHandler) {
        closeHandler.handle((Object)Future.succeededFuture());
    }

    public boolean isOpen() {
        return true;
    }

    public void setRequestTimeout(long timoutMillis) {
    }

    public int getCredit() {
        return 1;
    }

    public void sendQueueDrainHandler(Handler<Void> handler) {
        handler.handle(null);
    }

    public Future<Void> setLastKnownGatewayForDevice(String deviceId, String gatewayId, SpanContext context) {
        return this.cache.setLastKnownGatewayForDevice(this.tenantId, deviceId, gatewayId, context);
    }

    public Future<JsonObject> getLastKnownGatewayForDevice(String deviceId, SpanContext context) {
        return this.cache.getLastKnownGatewayForDevice(this.tenantId, deviceId, context);
    }

    public Future<Void> setCommandHandlingAdapterInstance(String deviceId, String adapterInstanceId, Duration lifespan, SpanContext context) {
        return this.cache.setCommandHandlingAdapterInstance(this.tenantId, deviceId, adapterInstanceId, lifespan, context);
    }

    public Future<Boolean> removeCommandHandlingAdapterInstance(String deviceId, String adapterInstanceId, SpanContext context) {
        return this.cache.removeCommandHandlingAdapterInstance(this.tenantId, deviceId, adapterInstanceId, context);
    }

    public Future<JsonObject> getCommandHandlingAdapterInstances(String deviceId, List<String> viaGateways, SpanContext context) {
        return this.cache.getCommandHandlingAdapterInstances(this.tenantId, deviceId, new HashSet<String>(viaGateways), context);
    }
}

