/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.client.ConnectionLifecycle;
import org.eclipse.hono.client.DisconnectListener;
import org.eclipse.hono.client.ReconnectListener;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.deviceconnection.infinispan.client.RemoteCache;
import org.eclipse.hono.deviceconnection.infinispan.client.Versioned;
import org.eclipse.hono.util.Futures;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.commons.api.BasicCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotrodCache<K, V>
implements RemoteCache<K, V>,
ConnectionLifecycle<HotrodCache<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(HotrodCache.class);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final Vertx vertx;
    private final RemoteCacheContainer cacheManager;
    private final String cacheName;
    private final K connectionCheckKey;
    private final V connectionCheckValue;
    private org.infinispan.client.hotrod.RemoteCache<K, V> cache;

    public HotrodCache(Vertx vertx, RemoteCacheContainer cacheManager, String name, K connectionCheckKey, V connectionCheckValue) {
        this.vertx = Objects.requireNonNull(vertx);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheName = Objects.requireNonNull(name);
        this.connectionCheckKey = Objects.requireNonNull(connectionCheckKey);
        this.connectionCheckValue = Objects.requireNonNull(connectionCheckValue);
    }

    public BasicCache<K, V> getCache() {
        return this.cache;
    }

    public Future<HotrodCache<K, V>> connect() {
        return this.connectToGrid().map(ok -> this);
    }

    public Future<Void> isConnected() {
        return this.checkForCacheAvailability().mapEmpty();
    }

    public void disconnect() {
        this.disconnect((Handler<AsyncResult<Void>>)((Handler)r -> {}));
    }

    public void disconnect(Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(r -> {
            try {
                if (this.cacheManager != null) {
                    this.cacheManager.stop();
                }
                r.complete();
            }
            catch (Throwable t) {
                r.fail(t);
            }
        }, stopAttempt -> {
            if (stopAttempt.succeeded()) {
                LOG.info("connection(s) to remote cache stopped successfully");
            } else {
                LOG.info("error trying to stop connection(s) to remote cache", stopAttempt.cause());
            }
            completionHandler.handle(stopAttempt);
        });
    }

    public void addDisconnectListener(DisconnectListener<HotrodCache<K, V>> listener) {
    }

    public void addReconnectListener(ReconnectListener<HotrodCache<K, V>> listener) {
    }

    @Override
    public Future<V> put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putAsync(key, value));
    }

    @Override
    public Future<V> put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(lifespanUnit);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putAsync(key, value, lifespan, lifespanUnit));
    }

    @Override
    public Future<Boolean> removeWithVersion(K key, long version) {
        Objects.requireNonNull(key);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersionAsync(key, version));
    }

    @Override
    public Future<V> get(K key) {
        Objects.requireNonNull(key);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.getAsync(key));
    }

    @Override
    public Future<Versioned<V>> getWithVersion(K key) {
        Objects.requireNonNull(key);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.getWithMetadataAsync(key).thenApply(value -> {
            if (value != null) {
                return new Versioned<Object>(value.getVersion(), value.getValue());
            }
            return null;
        }));
    }

    @Override
    public Future<Map<K, V>> getAll(Set<? extends K> keys) {
        Objects.requireNonNull(keys);
        if (this.cache == null) {
            return HotrodCache.noConnectionFailure();
        }
        return Futures.create(() -> this.cache.getAllAsync(keys));
    }

    private Future<Void> connectToGrid() {
        Promise result = Promise.promise();
        if (this.connecting.compareAndSet(false, true)) {
            this.vertx.executeBlocking(r -> {
                try {
                    if (!this.cacheManager.isStarted()) {
                        LOG.debug("trying to start cache manager");
                        this.cacheManager.start();
                        LOG.info("started cache manager, now connecting to remote cache");
                    }
                    LOG.debug("trying to connect to remote cache");
                    this.cache = this.cacheManager.getCache(this.cacheName, this.cacheManager.getConfiguration().forceReturnValues());
                    if (this.cache == null) {
                        r.fail((Throwable)new IllegalStateException("remote cache [" + this.cacheName + "] does not exist"));
                    } else {
                        this.cache.start();
                        r.complete(this.cache);
                    }
                }
                catch (Throwable t) {
                    r.fail(t);
                }
            }, attempt -> {
                if (attempt.succeeded()) {
                    LOG.info("successfully connected to remote cache");
                    result.complete();
                } else {
                    LOG.debug("failed to connect to remote cache: {}", (Object)attempt.cause().getMessage());
                    result.fail(attempt.cause());
                }
                this.connecting.set(false);
            });
        } else {
            LOG.info("already trying to establish connection to data grid");
            result.fail("already trying to establish connection to data grid");
        }
        return result.future();
    }

    @Override
    public Future<JsonObject> checkForCacheAvailability() {
        Promise result = Promise.promise();
        if (this.cacheManager.isStarted() && this.cache != null) {
            Instant start = Instant.now();
            this.put(this.connectionCheckKey, this.connectionCheckValue).setHandler(r -> {
                if (r.succeeded()) {
                    long requestDuration = Duration.between(start, Instant.now()).toMillis();
                    result.complete((Object)new JsonObject().put("grid-response-time", Long.valueOf(requestDuration)));
                } else {
                    LOG.debug("failed to put test value to cache", r.cause());
                    result.fail(r.cause());
                }
            });
        } else {
            this.connectToGrid();
            result.fail("not connected to data grid");
        }
        return result.future();
    }

    private static <V> Future<V> noConnectionFailure() {
        return Future.failedFuture((Throwable)new ServerErrorException(503, "no connection to data grid"));
    }
}

