/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.deviceconnection.infinispan.client.AdapterInstanceStatusProvider;
import org.eclipse.hono.deviceconnection.infinispan.client.Cache;
import org.eclipse.hono.deviceconnection.infinispan.client.DeviceConnectionInfo;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.AdapterInstanceStatus;
import org.eclipse.hono.util.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheBasedDeviceConnectionInfo
implements DeviceConnectionInfo,
ServiceClient,
Lifecycle {
    static final Duration LAST_KNOWN_GATEWAY_CACHE_ENTRY_LIFESPAN = Duration.ofDays(28L);
    static final int VIA_GATEWAYS_OPTIMIZATION_THRESHOLD = 3;
    private static final Logger LOG = LoggerFactory.getLogger(CacheBasedDeviceConnectionInfo.class);
    private static final String KEY_PREFIX_GATEWAY_ENTRIES_VALUE = "gw";
    private static final String KEY_PREFIX_ADAPTER_INSTANCE_VALUES = "ai";
    private static final String KEY_SEPARATOR = "@@";
    final Cache<String, String> cache;
    final Tracer tracer;
    final AdapterInstanceStatusProvider adapterInstanceStatusProvider;

    public CacheBasedDeviceConnectionInfo(Cache<String, String> cache, Tracer tracer) {
        this(cache, tracer, null);
    }

    public CacheBasedDeviceConnectionInfo(Cache<String, String> cache, Tracer tracer, AdapterInstanceStatusProvider adapterInstanceStatusProvider) {
        this.cache = Objects.requireNonNull(cache);
        this.tracer = Objects.requireNonNull(tracer);
        this.adapterInstanceStatusProvider = Optional.ofNullable(adapterInstanceStatusProvider).orElse(AdapterInstanceStatusProvider.UNKNOWN_STATUS_PROVIDER);
    }

    @Override
    public Future<Void> setLastKnownGatewayForDevice(String tenantId, String deviceId, String gatewayId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(span);
        long lifespanMillis = LAST_KNOWN_GATEWAY_CACHE_ENTRY_LIFESPAN.toMillis();
        return this.cache.put(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId), gatewayId, lifespanMillis, TimeUnit.MILLISECONDS).onSuccess(ok -> LOG.debug("set last known gateway [tenant: {}, device-id: {}, gateway: {}]", new Object[]{tenantId, deviceId, gatewayId})).otherwise(t -> {
            LOG.debug("failed to set last known gateway [tenant: {}, device-id: {}, gateway: {}]", new Object[]{tenantId, deviceId, gatewayId, t});
            TracingHelper.logError((Span)span, (String)"failed to set last known gateway", (Throwable)t);
            throw new ServerErrorException(tenantId, 500, t);
        });
    }

    @Override
    public Future<Void> setLastKnownGatewayForDevice(String tenantId, Map<String, String> deviceIdToGatewayIdMap, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceIdToGatewayIdMap);
        Objects.requireNonNull(span);
        if (deviceIdToGatewayIdMap.isEmpty()) {
            return Future.succeededFuture();
        }
        long lifespanMillis = LAST_KNOWN_GATEWAY_CACHE_ENTRY_LIFESPAN.toMillis();
        Map<String, String> mapToBePut = deviceIdToGatewayIdMap.entrySet().stream().collect(Collectors.toMap(entry -> CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, (String)entry.getKey()), Map.Entry::getValue));
        return this.cache.putAll(mapToBePut, lifespanMillis, TimeUnit.MILLISECONDS).onSuccess(ok -> LOG.debug("set {} last known gateway entries [tenant: {}]", (Object)deviceIdToGatewayIdMap.size(), (Object)tenantId)).otherwise(t -> {
            LOG.debug("failed to set {} last known gateway entries [tenant: {}]", new Object[]{deviceIdToGatewayIdMap.size(), tenantId, t});
            TracingHelper.logError((Span)span, (String)"failed to set last known gateway entries", (Throwable)t);
            throw new ServerErrorException(tenantId, 500, t);
        });
    }

    @Override
    public Future<JsonObject> getLastKnownGatewayForDevice(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).otherwise(t -> {
            LOG.debug("failed to find last known gateway for device [tenant: {}, device-id: {}]", new Object[]{tenantId, deviceId, t});
            TracingHelper.logError((Span)span, (String)"failed to find last known gateway for device", (Throwable)t);
            throw new ServerErrorException(tenantId, 500, t);
        }).compose(gatewayId -> {
            if (gatewayId == null) {
                LOG.debug("could not find last known gateway for device [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                return Future.failedFuture((Throwable)new ClientErrorException(404));
            }
            LOG.debug("found last known gateway for device [tenant: {}, device-id: {}]: {}", new Object[]{tenantId, deviceId, gatewayId});
            return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getLastKnownGatewayResultJson(gatewayId));
        });
    }

    @Override
    public Future<Void> setCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        Objects.requireNonNull(span);
        long lifespanMillis = lifespan == null || lifespan.isNegative() || lifespan.getSeconds() > 9223372036854775L ? -1L : lifespan.toMillis();
        return this.cache.put(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId), adapterInstanceId, lifespanMillis, TimeUnit.MILLISECONDS).onSuccess(ok -> LOG.debug("set command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}, lifespan: {}ms]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespanMillis})).otherwise(t -> {
            LOG.debug("failed to set command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}, lifespan: {}ms]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespanMillis, t});
            TracingHelper.logError((Span)span, (String)"failed to set command handling adapter instance cache entry", (Throwable)t);
            throw new ServerErrorException(tenantId, 500, t);
        });
    }

    @Override
    public Future<Void> removeCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        Objects.requireNonNull(span);
        return this.cache.remove(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId), adapterInstanceId).otherwise(t -> {
            LOG.debug("failed to remove the cache entry for the command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId, t});
            TracingHelper.logError((Span)span, (String)"failed to remove cache entry for the command handling adapter instance", (Throwable)t);
            throw new ServerErrorException(tenantId, 500, t);
        }).compose(removed -> {
            if (!removed.booleanValue()) {
                LOG.debug("command handling adapter instance was not removed, key not mapped or value didn't match [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
                return Future.failedFuture((Throwable)new ClientErrorException(412));
            }
            LOG.debug("removed command handling adapter instance [tenant: {}, device-id: {}, adapter-instance: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            return Future.succeededFuture();
        });
    }

    @Override
    public Future<JsonObject> getCommandHandlingAdapterInstances(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(viaGateways);
        Objects.requireNonNull(span);
        Object resultFuture = viaGateways.isEmpty() ? this.cache.get(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).map(adapterInstanceId -> this.checkAdapterInstanceId((String)adapterInstanceId, tenantId, deviceId, span)).compose(adapterInstanceId -> {
            if (adapterInstanceId == null) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no command handling adapter instances found for device (no via-gateways given)");
                return Future.failedFuture((Throwable)new ClientErrorException(404));
            }
            LOG.debug("found command handling adapter instance '{}' [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId});
            span.log("returning command handling adapter instance for device itself");
            this.setTagsForSingleResult(span, (String)adapterInstanceId);
            return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceId, adapterInstanceId));
        }) : (viaGateways.size() <= 3 ? this.getInstancesQueryingAllGatewaysFirst(tenantId, deviceId, viaGateways, span) : this.getInstancesGettingLastKnownGatewayFirst(tenantId, deviceId, viaGateways, span));
        return resultFuture;
    }

    private Future<JsonObject> getInstancesQueryingAllGatewaysFirst(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        LOG.debug("using optimized query, retrieving {} via-gateways in one go", (Object)viaGateways.size());
        return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, viaGateways)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).map(getAllMap -> this.checkAdapterInstanceIds(tenantId, CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap), span)).compose(deviceToInstanceMap -> {
            Future resultFuture;
            if (deviceToInstanceMap.isEmpty()) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no command handling adapter instances found for device or given via-gateways (" + String.join((CharSequence)", ", viaGateways) + ")");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(404));
            } else if (deviceToInstanceMap.containsKey(deviceId)) {
                resultFuture = this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, (String)deviceToInstanceMap.get(deviceId), span);
            } else if (deviceToInstanceMap.size() > 1) {
                resultFuture = this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).compose(lastKnownGateway -> {
                    if (lastKnownGateway == null) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (no last known gateway found) [tenant: {}, device-id: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId});
                        span.log("no last known gateway found, returning all matching adapter instances");
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    if (!viaGateways.contains(lastKnownGateway)) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (last known gateway not valid anymore) [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId, lastKnownGateway});
                        span.log(String.format("last known gateway '%s' is not valid anymore, returning all matching adapter instances", lastKnownGateway));
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    if (!deviceToInstanceMap.containsKey(lastKnownGateway)) {
                        LOG.debug("returning {} command handling adapter instances for device gateways (last known gateway not in that list) [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId, lastKnownGateway});
                        span.log(String.format("last known gateway '%s' has no adapter instance assigned, returning all matching adapter instances", lastKnownGateway));
                        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                    }
                    LOG.debug("returning command handling adapter instance '{}' for last known gateway [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.get(lastKnownGateway), tenantId, deviceId, lastKnownGateway});
                    span.log("returning adapter instance for last known gateway '" + lastKnownGateway + "'");
                    this.setTagsForSingleResultWithGateway(span, (String)deviceToInstanceMap.get(lastKnownGateway), (String)lastKnownGateway);
                    return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(lastKnownGateway, (String)deviceToInstanceMap.get(lastKnownGateway)));
                });
            } else {
                Map.Entry foundEntry = deviceToInstanceMap.entrySet().iterator().next();
                LOG.debug("returning command handling adapter instance '{}' associated with gateway {} [tenant: {}, device-id: {}]", new Object[]{foundEntry.getValue(), foundEntry.getKey(), tenantId, deviceId});
                span.log("returning adapter instance associated with gateway '" + (String)foundEntry.getKey() + "'");
                this.setTagsForSingleResultWithGateway(span, (String)foundEntry.getValue(), (String)foundEntry.getKey());
                resultFuture = Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson((String)foundEntry.getKey(), (String)foundEntry.getValue()));
            }
            return resultFuture;
        });
    }

    private void setTagsForSingleResultWithGateway(Span span, String adapterInstanceId, String gatewayId) {
        span.setTag("adapter_instance_id", adapterInstanceId);
        span.setTag("gateway_id", gatewayId);
    }

    private void setTagsForSingleResult(Span span, String adapterInstanceId) {
        span.setTag("adapter_instance_id", adapterInstanceId);
    }

    private Future<JsonObject> getInstancesGettingLastKnownGatewayFirst(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        return this.cache.get(CacheBasedDeviceConnectionInfo.getGatewayEntryKey(tenantId, deviceId)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).compose(lastKnownGateway -> {
            if (lastKnownGateway == null) {
                LOG.trace("no last known gateway found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no last known gateway found");
            } else if (!viaGateways.contains(lastKnownGateway)) {
                LOG.trace("found gateway is not valid for the device anymore [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("found gateway '" + lastKnownGateway + "' is not valid anymore");
            }
            if (lastKnownGateway != null && viaGateways.contains(lastKnownGateway)) {
                return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, lastKnownGateway)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).map(getAllMap -> this.checkAdapterInstanceIds(tenantId, CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap), span)).compose(deviceToInstanceMap -> {
                    if (deviceToInstanceMap.isEmpty()) {
                        span.log(String.format("last known gateway '%s' has no adapter instance assigned, returning all matching adapter instances", lastKnownGateway));
                        return this.getAdapterInstancesWithoutLastKnownGatewayCheck(tenantId, deviceId, viaGateways, span);
                    }
                    if (deviceToInstanceMap.containsKey(deviceId)) {
                        return this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, (String)deviceToInstanceMap.get(deviceId), span);
                    }
                    LOG.debug("returning command handling adapter instance '{}' for last known gateway [tenant: {}, device-id: {}, lastKnownGateway: {}]", new Object[]{deviceToInstanceMap.get(lastKnownGateway), tenantId, deviceId, lastKnownGateway});
                    span.log("returning adapter instance for last known gateway '" + lastKnownGateway + "'");
                    this.setTagsForSingleResultWithGateway(span, (String)deviceToInstanceMap.get(lastKnownGateway), (String)lastKnownGateway);
                    return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
                });
            }
            return this.getAdapterInstancesWithoutLastKnownGatewayCheck(tenantId, deviceId, viaGateways, span);
        });
    }

    private Future<JsonObject> getAdapterInstancesWithoutLastKnownGatewayCheck(String tenantId, String deviceId, Set<String> viaGateways, Span span) {
        return this.cache.getAll(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKeys(tenantId, deviceId, viaGateways)).recover(t -> this.failedToGetEntriesWhenGettingInstances(tenantId, deviceId, (Throwable)t, span)).map(getAllMap -> this.checkAdapterInstanceIds(tenantId, CacheBasedDeviceConnectionInfo.convertAdapterInstanceEntryKeys(getAllMap), span)).compose(deviceToInstanceMap -> {
            Future resultFuture;
            if (deviceToInstanceMap.isEmpty()) {
                LOG.debug("no command handling adapter instances found [tenant: {}, device-id: {}]", (Object)tenantId, (Object)deviceId);
                span.log("no command handling adapter instances found for device or given via-gateways (" + String.join((CharSequence)", ", viaGateways) + ")");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(404));
            } else if (deviceToInstanceMap.containsKey(deviceId)) {
                resultFuture = this.getAdapterInstanceFoundForDeviceItselfResult(tenantId, deviceId, (String)deviceToInstanceMap.get(deviceId), span);
            } else {
                LOG.debug("returning {} command handling adapter instance(s) (no last known gateway found) [tenant: {}, device-id: {}]", new Object[]{deviceToInstanceMap.size(), tenantId, deviceId});
                resultFuture = Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceToInstanceMap));
            }
            return resultFuture;
        });
    }

    private Future<JsonObject> getAdapterInstanceFoundForDeviceItselfResult(String tenantId, String deviceId, String adapterInstanceId, Span span) {
        LOG.debug("returning command handling adapter instance '{}' for device itself [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId});
        span.log("returning command handling adapter instance for device itself");
        this.setTagsForSingleResult(span, adapterInstanceId);
        return Future.succeededFuture((Object)CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(deviceId, adapterInstanceId));
    }

    private <T> Future<T> failedToGetEntriesWhenGettingInstances(String tenantId, String deviceId, Throwable t, Span span) {
        LOG.debug("failed to get cache entries when trying to get command handling adapter instances [tenant: {}, device-id: {}]", new Object[]{tenantId, deviceId, t});
        TracingHelper.logError((Span)span, (String)"failed to get cache entries when trying to get command handling adapter instances", (Throwable)t);
        return Future.failedFuture((Throwable)new ServerErrorException(500, t));
    }

    static String getGatewayEntryKey(String tenantId, String deviceId) {
        return "gw@@" + tenantId + KEY_SEPARATOR + deviceId;
    }

    static String getAdapterInstanceEntryKey(String tenantId, String deviceId) {
        return "ai@@" + tenantId + KEY_SEPARATOR + deviceId;
    }

    static Set<String> getAdapterInstanceEntryKeys(String tenantId, String deviceIdA, String deviceIdB) {
        HashSet<String> keys = new HashSet<String>(2);
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdA));
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdB));
        return keys;
    }

    private static Map<String, String> convertAdapterInstanceEntryKeys(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> CacheBasedDeviceConnectionInfo.getDeviceIdFromAdapterInstanceEntryKey((String)entry.getKey()), Map.Entry::getValue));
    }

    private static String getDeviceIdFromAdapterInstanceEntryKey(String key) {
        int pos = key.lastIndexOf(KEY_SEPARATOR);
        return key.substring(pos + KEY_SEPARATOR.length());
    }

    static Set<String> getAdapterInstanceEntryKeys(String tenantId, String deviceIdA, Set<String> additionalDeviceIds) {
        HashSet<String> keys = new HashSet<String>(additionalDeviceIds.size() + 1);
        keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceIdA));
        additionalDeviceIds.forEach(id -> keys.add(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, id)));
        return keys;
    }

    private static JsonObject getLastKnownGatewayResultJson(String gatewayId) {
        return new JsonObject().put("gateway-id", (Object)gatewayId);
    }

    private static JsonObject getAdapterInstancesResultJson(Map<String, String> deviceToAdapterInstanceMap) {
        JsonObject jsonObject = new JsonObject();
        JsonArray adapterInstancesArray = new JsonArray(new ArrayList(deviceToAdapterInstanceMap.size()));
        for (Map.Entry<String, String> resultEntry : deviceToAdapterInstanceMap.entrySet()) {
            JsonObject entryJson = new JsonObject();
            entryJson.put("device-id", (Object)resultEntry.getKey());
            entryJson.put("adapter-instance-id", (Object)resultEntry.getValue());
            adapterInstancesArray.add((Object)entryJson);
        }
        jsonObject.put("adapter-instances", (Object)adapterInstancesArray);
        return jsonObject;
    }

    private static JsonObject getAdapterInstancesResultJson(String deviceId, String adapterInstanceId) {
        return CacheBasedDeviceConnectionInfo.getAdapterInstancesResultJson(Map.of(deviceId, adapterInstanceId));
    }

    private Map<String, String> checkAdapterInstanceIds(String tenantId, Map<String, String> deviceToInstanceIdMap, Span span) {
        return deviceToInstanceIdMap.entrySet().stream().filter(deviceToInstanceId -> this.checkAdapterInstanceId((String)deviceToInstanceId.getValue(), tenantId, (String)deviceToInstanceId.getKey(), span) != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String checkAdapterInstanceId(String adapterInstanceId, String tenantId, String deviceId, Span span) {
        if (adapterInstanceId != null) {
            AdapterInstanceStatus status = this.adapterInstanceStatusProvider.getStatus(adapterInstanceId);
            if (status == AdapterInstanceStatus.DEAD) {
                LOG.debug("ignoring found adapter instance id, belongs to already terminated container [tenant: {}, device-id: {}, adapter-instance-id: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
                span.log("ignoring found adapter instance id [" + adapterInstanceId + "], belongs to already terminated container");
                this.cache.remove(CacheBasedDeviceConnectionInfo.getAdapterInstanceEntryKey(tenantId, deviceId), adapterInstanceId).onSuccess(removed -> {
                    if (removed.booleanValue()) {
                        LOG.debug("removed entry with obsolete adapter instance id '{}' [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId});
                    }
                }).onFailure(thr -> LOG.debug("error removing entry with obsolete adapter instance id '{}' [tenant: {}, device-id: {}]", new Object[]{adapterInstanceId, tenantId, deviceId, thr}));
                return null;
            }
            if (status == AdapterInstanceStatus.SUSPECTED_DEAD) {
                LOG.debug("ignoring found adapter instance id, belongs to container with state 'SUSPECTED_DEAD' [tenant: {}, device-id: {}, adapter-instance-id: {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
                span.log("ignoring found adapter instance id [" + adapterInstanceId + "], belongs to container with state 'SUSPECTED_DEAD'");
                return null;
            }
        }
        return adapterInstanceId;
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register("remote-cache-connection", 1000L, this::checkForCacheAvailability);
    }

    private void checkForCacheAvailability(Promise<Status> status) {
        this.cache.checkForCacheAvailability().map(Status::OK).otherwise(t -> Status.KO()).onComplete(ar -> status.tryComplete((Object)((Status)ar.result())));
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    public Future<Void> start() {
        if (this.cache instanceof Lifecycle) {
            return ((Lifecycle)this.cache).start();
        }
        return Future.succeededFuture();
    }

    public Future<Void> stop() {
        if (this.cache instanceof Lifecycle) {
            return ((Lifecycle)this.cache).stop();
        }
        return Future.succeededFuture();
    }
}

