/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import com.google.common.base.MoreObjects;
import java.util.Map;
import org.eclipse.hono.deviceconnection.infinispan.client.InfinispanRemoteConfigurationOptions;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanRemoteConfigurationProperties
extends ConfigurationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(InfinispanRemoteConfigurationProperties.class);

    public InfinispanRemoteConfigurationProperties() {
    }

    public InfinispanRemoteConfigurationProperties(InfinispanRemoteConfigurationOptions options) {
        options.authPassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthPassword(arg_0));
        options.authRealm().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthRealm(arg_0));
        options.authServerName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthServerName(arg_0));
        options.authUsername().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setAuthUsername(arg_0));
        this.setCluster(options.cluster());
        this.setConnectionPool(options.connectionPool());
        this.setConnectTimeout(options.connectTimeout());
        options.keyAlias().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyAlias(arg_0));
        options.keyStoreCertificatePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreCertificatePassword(arg_0));
        options.keyStoreFileName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreFileName(arg_0));
        options.keyStorePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStorePassword(arg_0));
        options.keyStoreType().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setKeyStoreType(arg_0));
        options.saslMechanism().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setSaslMechanism(arg_0));
        this.setSaslProperties(options.saslProperties());
        options.serverList().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setServerList(arg_0));
        this.setSocketTimeout(options.socketTimeout());
        options.trustStoreFileName().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStoreFileName(arg_0));
        options.trustStorePassword().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStorePassword(arg_0));
        options.trustStorePath().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStorePath(arg_0));
        options.trustStoreType().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setTrustStoreType(arg_0));
        this.setUseSSL(options.useSsl());
        options.sslCiphers().ifPresent(this::setSSLCiphers);
        options.sslProtocol().ifPresent(arg_0 -> ((InfinispanRemoteConfigurationProperties)this).setSSLProtocol(arg_0));
    }

    public final ConfigurationBuilder getConfigurationBuilder() {
        return new ConfigurationBuilder().withProperties(this.getProperties());
    }

    public final void setConnectionPool(Map<String, String> poolProperties) {
        poolProperties.forEach((k, v) -> {
            String key = String.format("%s.%s", "infinispan.client.hotrod.connection_pool", k);
            LOG.debug("setting configuration property [{}: {}]", (Object)key, v);
            this.getProperties().setProperty(key, (String)v);
        });
    }

    public final void setSaslProperties(Map<String, String> saslProperties) {
        saslProperties.forEach((k, v) -> {
            String key = String.format("%s.%s", "infinispan.client.hotrod.sasl_properties", k);
            this.getProperties().setProperty(key, (String)v);
        });
    }

    public final void setCluster(Map<String, String> cluster) {
        cluster.forEach((k, v) -> {
            String key = String.format("%s.%s", "infinispan.client.hotrod.cluster", k);
            this.getProperties().setProperty(key, (String)v);
        });
    }

    public String getSSLCiphers() {
        return this.getProperties().getProperty("infinispan.client.hotrod.ssl_ciphers");
    }

    public void setSSLCiphers(String ciphers) {
        this.getProperties().put("infinispan.client.hotrod.ssl_ciphers", ciphers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("serverList", (Object)this.getServerList()).add("authUsername", (Object)this.getAuthUsername()).toString();
    }
}

