/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.services.gateway.streaming.StreamControlMessage;
import org.eclipse.ditto.services.utils.pubsub.StreamingType;

@JsonParsableCommandResponse(type="gateway:streaming.ack")
public final class StreamingAck
implements Jsonifiable.WithPredicate<JsonObject, JsonField>,
StreamControlMessage {
    static final String TYPE = "gateway:streaming.ack";
    private static final JsonFieldDefinition<String> JSON_STREAMING_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"streamingType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    private static final JsonFieldDefinition<Boolean> JSON_SUBSCRIBED = JsonFactory.newBooleanFieldDefinition((CharSequence)"subscribed", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    private final StreamingType streamingType;
    private final boolean subscribed;

    public StreamingAck(StreamingType streamingType, boolean subscribed) {
        this.streamingType = streamingType;
        this.subscribed = subscribed;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public static StreamingAck fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        String streamingType = (String)jsonObject.getValueOrThrow(JSON_STREAMING_TYPE);
        boolean subscribed = (Boolean)jsonObject.getValueOrThrow(JSON_SUBSCRIBED);
        return new StreamingAck(StreamingType.fromTopic((String)streamingType), subscribed);
    }

    @Nonnull
    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Nonnull
    public JsonObject toJson(@Nonnull JsonSchemaVersion schemaVersion, @Nonnull Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonObject.newBuilder();
        jsonObjectBuilder.set(JSON_STREAMING_TYPE, (Object)this.streamingType.getDistributedPubSubTopic(), predicate);
        jsonObjectBuilder.set(JSON_SUBSCRIBED, (Object)this.subscribed, predicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamingAck)) {
            return false;
        }
        StreamingAck that = (StreamingAck)o;
        return this.subscribed == that.subscribed && this.streamingType == that.streamingType;
    }

    public int hashCode() {
        return Objects.hash(this.streamingType, this.subscribed);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingType=" + this.streamingType + ", subscribed=" + this.subscribed + "]";
    }
}

