/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.japi.function.Function;
import akka.stream.KillSwitch;
import akka.stream.KillSwitches;
import akka.stream.OverflowStrategy;
import akka.stream.javadsl.Keep;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import java.io.Serializable;
import java.util.function.Consumer;
import org.eclipse.ditto.services.gateway.streaming.actors.DefaultSupervisedStream;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedJsonifiable;

public interface SupervisedStream {
    public static Source<SessionedJsonifiable, WithQueue> sourceQueue(int queueSize) {
        return Source.queue((int)queueSize, (OverflowStrategy)OverflowStrategy.fail()).viaMat(KillSwitches.single(), Keep.both()).mapMaterializedValue((Function & Serializable)pair -> {
            SourceQueueWithComplete sourceQueue = (SourceQueueWithComplete)pair.first();
            KillSwitch killSwitch = (KillSwitch)pair.second();
            DefaultSupervisedStream supervised = new DefaultSupervisedStream(killSwitch, sourceQueue.watchCompletion());
            return new WithQueue((SourceQueueWithComplete<SessionedJsonifiable>)sourceQueue, supervised);
        });
    }

    public void whenComplete(Consumer<? super Throwable> var1);

    public void shutdown();

    public void abort(Throwable var1);

    public static final class WithQueue {
        private final SourceQueueWithComplete<SessionedJsonifiable> sourceQueue;
        private final SupervisedStream supervisedStream;

        private WithQueue(SourceQueueWithComplete<SessionedJsonifiable> sourceQueue, SupervisedStream supervisedStream) {
            this.sourceQueue = sourceQueue;
            this.supervisedStream = supervisedStream;
        }

        public SourceQueueWithComplete<SessionedJsonifiable> getSourceQueue() {
            return this.sourceQueue;
        }

        public SupervisedStream getSupervisedStream() {
            return this.supervisedStream;
        }
    }
}

