/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.Done;
import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.PoisonPill;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.japi.pf.PFBuilder;
import akka.japi.pf.ReceiveBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.acks.AbstractCommandAckRequestSetter;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.entity.id.EntityIdWithType;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.jwt.ImmutableJsonWebToken;
import org.eclipse.ditto.model.jwt.JsonWebToken;
import org.eclipse.ditto.model.namespaces.NamespaceReader;
import org.eclipse.ditto.model.query.criteria.Criteria;
import org.eclipse.ditto.model.query.criteria.CriteriaFactory;
import org.eclipse.ditto.model.query.criteria.CriteriaFactoryImpl;
import org.eclipse.ditto.model.query.expression.ThingsFieldExpressionFactory;
import org.eclipse.ditto.model.query.filter.QueryFilterCriteriaFactory;
import org.eclipse.ditto.model.query.things.ModelBasedThingsFieldExpressionFactory;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.WithThingId;
import org.eclipse.ditto.protocoladapter.HeaderTranslator;
import org.eclipse.ditto.protocoladapter.TopicPath;
import org.eclipse.ditto.services.gateway.security.authentication.AuthenticationResult;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthenticationResultProvider;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtValidator;
import org.eclipse.ditto.services.gateway.streaming.CloseStreamExceptionally;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.IncomingSignal;
import org.eclipse.ditto.services.gateway.streaming.InvalidJwt;
import org.eclipse.ditto.services.gateway.streaming.Jwt;
import org.eclipse.ditto.services.gateway.streaming.RefreshSession;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedJsonifiable;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSession;
import org.eclipse.ditto.services.models.acks.AcknowledgementAggregatorActorStarter;
import org.eclipse.ditto.services.models.acks.AcknowledgementForwarderActor;
import org.eclipse.ditto.services.models.acks.config.AcknowledgementConfig;
import org.eclipse.ditto.services.models.concierge.pubsub.DittoProtocolSub;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;
import org.eclipse.ditto.services.utils.akka.logging.DittoDiagnosticLoggingAdapter;
import org.eclipse.ditto.services.utils.akka.logging.DittoLoggerFactory;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.base.WithId;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.base.exceptions.GatewayWebsocketSessionClosedException;
import org.eclipse.ditto.signals.commands.base.exceptions.GatewayWebsocketSessionExpiredException;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.commands.messages.acks.MessageCommandAckRequestSetter;
import org.eclipse.ditto.signals.commands.things.acks.ThingLiveCommandAckRequestSetter;
import org.eclipse.ditto.signals.commands.things.acks.ThingModifyCommandAckRequestSetter;
import org.eclipse.ditto.signals.commands.thingsearch.ThingSearchCommand;
import org.eclipse.ditto.signals.events.base.Event;
import org.eclipse.ditto.signals.events.thingsearch.SubscriptionEvent;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

final class StreamingSessionActor
extends AbstractActorWithTimers {
    private final JsonSchemaVersion jsonSchemaVersion;
    private final String connectionCorrelationId;
    private final String type;
    private final DittoProtocolSub dittoProtocolSub;
    private final ActorRef eventAndResponsePublisher;
    private final ActorRef commandRouter;
    private final AcknowledgementConfig acknowledgementConfig;
    private final ActorRef subscriptionManager;
    private final Set<StreamingType> outstandingSubscriptionAcks;
    private final Map<StreamingType, StreamingSession> streamingSessions;
    private final JwtValidator jwtValidator;
    private final JwtAuthenticationResultProvider jwtAuthenticationResultProvider;
    private final AcknowledgementAggregatorActorStarter ackregatorStarter;
    private final DittoDiagnosticLoggingAdapter logger;
    @Nullable
    private Cancellable sessionTerminationCancellable;
    private AuthorizationContext authorizationContext;

    private StreamingSessionActor(Connect connect, DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, AcknowledgementConfig acknowledgementConfig, HeaderTranslator headerTranslator, Props subscriptionManagerProps, JwtValidator jwtValidator, JwtAuthenticationResultProvider jwtAuthenticationResultProvider) {
        this.jsonSchemaVersion = connect.getJsonSchemaVersion();
        this.connectionCorrelationId = connect.getConnectionCorrelationId();
        this.type = connect.getType();
        this.dittoProtocolSub = dittoProtocolSub;
        this.eventAndResponsePublisher = connect.getEventAndResponsePublisher();
        this.commandRouter = commandRouter;
        this.acknowledgementConfig = acknowledgementConfig;
        this.jwtValidator = jwtValidator;
        this.jwtAuthenticationResultProvider = jwtAuthenticationResultProvider;
        this.outstandingSubscriptionAcks = EnumSet.noneOf(StreamingType.class);
        this.authorizationContext = AuthorizationModelFactory.emptyAuthContext();
        this.streamingSessions = new EnumMap<StreamingType, StreamingSession>(StreamingType.class);
        this.ackregatorStarter = AcknowledgementAggregatorActorStarter.of((ActorContext)this.getContext(), (AcknowledgementConfig)acknowledgementConfig, (HeaderTranslator)headerTranslator, (AbstractCommandAckRequestSetter[])new AbstractCommandAckRequestSetter[]{ThingModifyCommandAckRequestSetter.getInstance(), ThingLiveCommandAckRequestSetter.getInstance(), MessageCommandAckRequestSetter.getInstance()});
        this.logger = DittoLoggerFactory.getDiagnosticLoggingAdapter((Actor)this);
        this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
        connect.getSessionExpirationTime().ifPresent(expiration -> {
            this.sessionTerminationCancellable = this.startSessionTimeout((Instant)expiration);
        });
        this.subscriptionManager = this.getContext().actorOf(subscriptionManagerProps, "subscriptionManager");
        this.getContext().watch(this.eventAndResponsePublisher);
    }

    static Props props(Connect connect, DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, AcknowledgementConfig acknowledgementConfig, HeaderTranslator headerTranslator, Props subscriptionManagerProps, JwtValidator jwtValidator, JwtAuthenticationResultProvider jwtAuthenticationResultProvider) {
        return Props.create(StreamingSessionActor.class, (Object[])new Object[]{connect, dittoProtocolSub, commandRouter, acknowledgementConfig, headerTranslator, subscriptionManagerProps, jwtValidator, jwtAuthenticationResultProvider});
    }

    public void postStop() {
        this.cancelSessionTimeout();
        this.logger.info("Closing <{}> streaming session.", (Object)this.type);
    }

    public AbstractActor.Receive createReceive() {
        return this.createIncomingSignalBehavior().orElse(this.createOutgoingSignalBehavior()).orElse(this.createPubSubBehavior()).orElse(this.createSelfTerminationBehavior()).orElse(this.logUnknownMessage());
    }

    private AbstractActor.Receive createIncomingSignalBehavior() {
        PartialFunction stripEnvelope = new PFBuilder().match(IncomingSignal.class, IncomingSignal::getSignal).build();
        PartialFunction setAckRequestAndStartAckregator = new PFBuilder().match(Signal.class, this::startAckregatorAndForward).matchAny(x -> x).build();
        AbstractActor.Receive signalBehavior = ReceiveBuilder.create().match(CommandResponse.class, this::forwardAcknowledgementOrLiveCommandResponse).match(ThingSearchCommand.class, this::forwardSearchCommand).match(Signal.class, signal -> this.commandRouter.tell(signal, this.getReturnAddress((Signal<?>)signal))).matchEquals((Object)Done.getInstance(), done -> {}).build();
        return this.addPreprocessors(List.of(stripEnvelope, setAckRequestAndStartAckregator), signalBehavior);
    }

    private AbstractActor.Receive createOutgoingSignalBehavior() {
        PartialFunction setCorrelationIdAndStartAckForwarder = new PFBuilder().match(Signal.class, signal -> {
            this.logger.setCorrelationId((WithDittoHeaders)signal);
            return this.startAckForwarder((Signal<?>)signal);
        }).match(DittoRuntimeException.class, x -> x).build();
        AbstractActor.Receive publishSignal = ReceiveBuilder.create().match(SubscriptionEvent.class, signal -> {
            this.logger.debug("Got SubscriptionEvent in <{}> session, publishing: {}", (Object)this.type, signal);
            this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.subscription(signal), this.getSelf());
        }).match(CommandResponse.class, this::publishResponseOrError).match(DittoRuntimeException.class, this::publishResponseOrError).match(Signal.class, this::isSameOrigin, signal -> this.logger.debug("Got Signal <{}> in <{}> session, but this was issued by  this connection itself, not publishing", (Object)signal.getType(), (Object)this.type)).match(Signal.class, signal -> {
            StreamingSession session = this.streamingSessions.get(StreamingSessionActor.determineStreamingType(signal));
            if (null != session && this.isSessionAllowedToReceiveSignal((Signal<?>)signal, session)) {
                this.logger.debug("Got Signal in <{}> session, publishing: {}", (Object)this.type, signal);
                DittoHeaders sessionHeaders = DittoHeaders.newBuilder().authorizationContext(this.authorizationContext).schemaVersion(this.jsonSchemaVersion).build();
                SessionedJsonifiable sessionedJsonifiable = SessionedJsonifiable.signal(signal, sessionHeaders, session);
                this.eventAndResponsePublisher.tell((Object)sessionedJsonifiable, this.getSelf());
            }
        }).matchEquals((Object)Done.getInstance(), done -> {}).build();
        return this.addPreprocessors(List.of(setCorrelationIdAndStartAckForwarder), publishSignal);
    }

    private AbstractActor.Receive createPubSubBehavior() {
        return ReceiveBuilder.create().match(StartStreaming.class, startStreaming -> {
            Criteria criteria;
            this.authorizationContext = startStreaming.getAuthorizationContext();
            this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
            try {
                criteria = startStreaming.getFilter().map(f -> StreamingSessionActor.parseCriteria(f, DittoHeaders.newBuilder().correlationId((CharSequence)startStreaming.getConnectionCorrelationId()).build())).orElse(null);
            }
            catch (DittoRuntimeException e) {
                this.logger.info("Got 'DittoRuntimeException' <{}> session during 'StartStreaming' processing: {}: <{}>", (Object)this.type, (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
                this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.error(e), this.getSelf());
                return;
            }
            StreamingSession session = StreamingSession.of(startStreaming.getNamespaces(), criteria, startStreaming.getExtraFields().orElse(null));
            this.streamingSessions.put(startStreaming.getStreamingType(), session);
            this.logger.debug("Got 'StartStreaming' message in <{}> session, subscribing for <{}> in Cluster ...", (Object)this.type, (Object)startStreaming.getStreamingType().name());
            this.outstandingSubscriptionAcks.add(startStreaming.getStreamingType());
            ConfirmSubscription subscribeConfirmation = new ConfirmSubscription(startStreaming.getStreamingType());
            Set<StreamingType> currentStreamingTypes = this.streamingSessions.keySet();
            this.dittoProtocolSub.subscribe(currentStreamingTypes, (Collection)this.authorizationContext.getAuthorizationSubjectIds(), this.getSelf()).thenAccept(ack -> this.getSelf().tell((Object)subscribeConfirmation, this.getSelf()));
        }).match(StopStreaming.class, stopStreaming -> {
            this.logger.debug("Got 'StopStreaming' message in <{}> session, unsubscribing from <{}> in Cluster ...", (Object)this.type, (Object)stopStreaming.getStreamingType().name());
            this.streamingSessions.remove(stopStreaming.getStreamingType());
            ConfirmUnsubscription unsubscribeConfirmation = new ConfirmUnsubscription(stopStreaming.getStreamingType());
            Set<StreamingType> currentStreamingTypes = this.streamingSessions.keySet();
            if (stopStreaming.getStreamingType() != StreamingType.EVENTS) {
                this.dittoProtocolSub.updateLiveSubscriptions(currentStreamingTypes, (Collection)this.authorizationContext.getAuthorizationSubjectIds(), this.getSelf()).thenAccept(ack -> this.getSelf().tell((Object)unsubscribeConfirmation, this.getSelf()));
            } else {
                this.dittoProtocolSub.removeTwinSubscriber(this.getSelf(), (Collection)this.authorizationContext.getAuthorizationSubjectIds()).thenAccept(ack -> this.getSelf().tell((Object)unsubscribeConfirmation, this.getSelf()));
            }
        }).match(ConfirmSubscription.class, msg -> this.confirmSubscription(msg.getStreamingType(), this.getSelf())).match(ConfirmUnsubscription.class, msg -> this.confirmUnsubscription(msg.getStreamingType(), this.getSelf())).build();
    }

    private AbstractActor.Receive createSelfTerminationBehavior() {
        return ReceiveBuilder.create().match(Jwt.class, this::refreshWebSocketSession).match(RefreshSession.class, refreshSession -> {
            this.cancelSessionTimeout();
            this.checkAuthorizationContextAndStartSessionTimer((RefreshSession)refreshSession);
        }).match(InvalidJwt.class, invalidJwtToken -> this.cancelSessionTimeout()).match(Terminated.class, terminated -> {
            this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
            this.logger.debug("EventAndResponsePublisher was terminated.");
            this.logger.info("<{}> connection was closed, unsubscribing from Streams in Cluster ...", (Object)this.type);
            this.dittoProtocolSub.removeSubscriber(this.getSelf());
            PoisonPill$ poisonPill = PoisonPill.getInstance();
            this.getTimers().startSingleTimer((Object)poisonPill, (Object)poisonPill, Duration.ofSeconds(1L));
        }).build();
    }

    private AbstractActor.Receive logUnknownMessage() {
        return ReceiveBuilder.create().matchAny(any -> this.logger.withCorrelationId((CharSequence)this.connectionCorrelationId).warning("Got unknown message in '{}' session: '{}'", (Object)this.type, any)).build();
    }

    private AbstractActor.Receive addPreprocessors(List<PartialFunction<Object, Object>> preprocessors, AbstractActor.Receive receive) {
        return preprocessors.stream().reduce(PartialFunction::andThen).map(preprocessor -> new AbstractActor.Receive(preprocessor.andThen((Function1)receive.onMessage()))).orElse(receive);
    }

    private ActorRef getReturnAddress(Signal<?> signal) {
        boolean publishResponse = signal instanceof Command && signal.getDittoHeaders().isResponseRequired();
        return publishResponse ? this.getSelf() : ActorRef.noSender();
    }

    private boolean isSameOrigin(Signal<?> signal) {
        return signal.getDittoHeaders().getOrigin().stream().anyMatch(this.connectionCorrelationId::equals);
    }

    private Object startAckregatorAndForward(Signal<?> signal) {
        return this.ackregatorStarter.preprocess(signal, (s, shouldStart) -> {
            if (shouldStart.booleanValue()) {
                Optional<DittoHeaderInvalidException> headerInvalid = StreamingSessionActor.checkForAcksWithoutResponse(s);
                return headerInvalid.map(this::publishResponseWithoutSender).orElseGet(() -> this.ackregatorStarter.doStart(s, this::publishResponseWithoutSender, ackregator -> this.forwardToCommandRouterAndReturnDone((Signal<?>)s, (ActorRef)ackregator)));
            }
            return this.doNothing(s);
        }, this::publishResponseWithoutSender);
    }

    private Object forwardToCommandRouterAndReturnDone(Signal<?> signalToForward, ActorRef ackregator) {
        this.commandRouter.tell(signalToForward, ackregator);
        return Done.getInstance();
    }

    private <T> Object doNothing(T result) {
        return result;
    }

    private Signal<?> startAckForwarder(Signal<?> signal) {
        if (signal instanceof WithThingId) {
            ThingId entityIdWithType = ((WithThingId)signal).getThingEntityId();
            return AcknowledgementForwarderActor.startAcknowledgementForwarderConflictFree((ActorContext)this.getContext(), (EntityIdWithType)entityIdWithType, signal, (AcknowledgementConfig)this.acknowledgementConfig);
        }
        return signal;
    }

    private void publishResponseOrError(Object responseOrError) {
        this.publishResponseThreadSafely(responseOrError, this.getSender());
    }

    private Object publishResponseWithoutSender(Object responseOrError) {
        this.publishResponseThreadSafely(responseOrError, ActorRef.noSender());
        return Done.getInstance();
    }

    private void publishResponseThreadSafely(Object responseOrError, @Nullable ActorRef sender) {
        if (responseOrError instanceof CommandResponse) {
            CommandResponse response = (CommandResponse)responseOrError;
            this.logger.withCorrelationId((WithDittoHeaders)response).debug("Got 'CommandResponse' message in <{}> session, telling EventAndResponsePublisher about it: {}", (Object)this.type, (Object)response);
            this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.response(response), sender);
        } else if (responseOrError instanceof DittoRuntimeException) {
            DittoRuntimeException error = (DittoRuntimeException)((Object)responseOrError);
            this.logger.withCorrelationId((WithDittoHeaders)error).debug("Got 'DittoRuntimeException' message in <{}> session, telling EventAndResponsePublisher about it: {}", (Object)this.type, (Object)error);
            this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.error(error), sender);
        } else {
            this.logger.error("Unexpected result from AcknowledgementAggregatorActor: <{}>", responseOrError);
        }
    }

    private void forwardAcknowledgementOrLiveCommandResponse(CommandResponse<?> response) {
        AbstractActor.ActorContext context = this.getContext();
        context.findChild(AcknowledgementForwarderActor.determineActorName((DittoHeaders)response.getDittoHeaders())).ifPresentOrElse(forwarder -> forwarder.forward((Object)response, (ActorContext)context), () -> this.logger.withCorrelationId((WithDittoHeaders)response).info("Received Acknowledgement / live CommandResponse but no AcknowledgementForwarderActor was present: <{}>", (Object)response));
    }

    private void forwardSearchCommand(ThingSearchCommand<?> searchCommand) {
        this.subscriptionManager.tell(searchCommand, this.getSelf());
    }

    private boolean isSessionAllowedToReceiveSignal(Signal<?> signal, StreamingSession session) {
        DittoHeaders headers = signal.getDittoHeaders();
        boolean isAuthorizedToRead = this.authorizationContext.isAuthorized((Collection)headers.getReadGrantedSubjects(), (Collection)headers.getReadRevokedSubjects());
        boolean matchesNamespace = this.matchesNamespaces(signal, session);
        return isAuthorizedToRead && matchesNamespace;
    }

    private Cancellable startSessionTimeout(Instant sessionExpirationTime) {
        long timeout = sessionExpirationTime.minusMillis(Instant.now().toEpochMilli()).toEpochMilli();
        this.logger.debug("Starting session timeout - session will expire in {} ms", (Object)timeout);
        FiniteDuration sessionExpirationTimeMillis = FiniteDuration.apply((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        return this.getContext().getSystem().getScheduler().scheduleOnce(sessionExpirationTimeMillis, this::handleSessionTimeout, (ExecutionContext)this.getContext().getDispatcher());
    }

    private void handleSessionTimeout() {
        this.logger.info("Stopping WebSocket session for connection with ID <{}>.", (Object)this.connectionCorrelationId);
        GatewayWebsocketSessionExpiredException gatewayWebsocketSessionExpiredException = (GatewayWebsocketSessionExpiredException)GatewayWebsocketSessionExpiredException.newBuilder().dittoHeaders(DittoHeaders.newBuilder().correlationId((CharSequence)this.connectionCorrelationId).build()).build();
        this.eventAndResponsePublisher.tell((Object)CloseStreamExceptionally.getInstance((DittoRuntimeException)gatewayWebsocketSessionExpiredException, this.connectionCorrelationId), this.getSelf());
    }

    private void cancelSessionTimeout() {
        if (null != this.sessionTerminationCancellable) {
            this.sessionTerminationCancellable.cancel();
        }
    }

    private void checkAuthorizationContextAndStartSessionTimer(RefreshSession refreshSession) {
        AuthorizationContext newAuthorizationContext = refreshSession.getAuthorizationContext();
        if (!this.authorizationContext.equals(newAuthorizationContext)) {
            this.logger.debug("Authorization Context changed for WebSocket session <{}>. Terminating the session.", (Object)this.connectionCorrelationId);
            GatewayWebsocketSessionClosedException gatewayWebsocketSessionClosedException = (GatewayWebsocketSessionClosedException)GatewayWebsocketSessionClosedException.newBuilder().dittoHeaders(DittoHeaders.newBuilder().correlationId((CharSequence)this.connectionCorrelationId).build()).build();
            this.eventAndResponsePublisher.tell((Object)CloseStreamExceptionally.getInstance((DittoRuntimeException)gatewayWebsocketSessionClosedException, this.connectionCorrelationId), this.getSelf());
        } else {
            this.sessionTerminationCancellable = this.startSessionTimeout(refreshSession.getSessionTimeout());
        }
    }

    private boolean matchesNamespaces(Signal<?> signal, StreamingSession session) {
        boolean result;
        List<String> namespaces = session.getNamespaces();
        boolean bl = result = namespaces.isEmpty() || namespaces.contains(StreamingSessionActor.namespaceFromId(signal));
        if (!result) {
            this.logger.debug("Signal does not match namespaces.");
        }
        return result;
    }

    private void refreshWebSocketSession(Jwt jwt) {
        String jwtConnectionCorrelationId = jwt.getConnectionCorrelationId();
        JsonWebToken jsonWebToken = ImmutableJsonWebToken.fromToken((String)jwt.toString());
        this.jwtValidator.validate(jsonWebToken).thenAccept(binaryValidationResult -> {
            if (binaryValidationResult.isValid()) {
                try {
                    AuthenticationResult authorizationResult = this.jwtAuthenticationResultProvider.getAuthenticationResult(jsonWebToken, DittoHeaders.empty());
                    AuthorizationContext jwtAuthorizationContext = authorizationResult.getDittoHeaders().getAuthorizationContext();
                    this.getSelf().tell((Object)new RefreshSession(jwtConnectionCorrelationId, jsonWebToken.getExpirationTime(), jwtAuthorizationContext), ActorRef.noSender());
                }
                catch (Exception exception) {
                    this.logger.info("Got exception when handling refreshed JWT for WebSocket session <{}>: {}", (Object)jwtConnectionCorrelationId, (Object)exception.getMessage());
                    this.getSelf().tell((Object)InvalidJwt.getInstance(), ActorRef.noSender());
                }
            } else {
                this.getSelf().tell((Object)InvalidJwt.getInstance(), ActorRef.noSender());
            }
        });
    }

    private static StreamingType determineStreamingType(Signal<?> signal) {
        String channel = signal.getDittoHeaders().getChannel().orElse(TopicPath.Channel.TWIN.getName());
        StreamingType streamingType = signal instanceof Event ? (channel.equals(TopicPath.Channel.TWIN.getName()) ? StreamingType.EVENTS : StreamingType.LIVE_EVENTS) : (signal instanceof MessageCommand ? StreamingType.MESSAGES : StreamingType.LIVE_COMMANDS);
        return streamingType;
    }

    @Nullable
    private static String namespaceFromId(WithId withId) {
        return NamespaceReader.fromEntityId((EntityId)withId.getEntityId()).orElse(null);
    }

    private static Criteria parseCriteria(String filter, DittoHeaders dittoHeaders) {
        CriteriaFactoryImpl criteriaFactory = new CriteriaFactoryImpl();
        ModelBasedThingsFieldExpressionFactory fieldExpressionFactory = new ModelBasedThingsFieldExpressionFactory();
        QueryFilterCriteriaFactory queryFilterCriteriaFactory = new QueryFilterCriteriaFactory((CriteriaFactory)criteriaFactory, (ThingsFieldExpressionFactory)fieldExpressionFactory);
        return queryFilterCriteriaFactory.filterCriteria(filter, dittoHeaders);
    }

    private void confirmSubscription(StreamingType streamingType, ActorRef self) {
        if (this.outstandingSubscriptionAcks.contains(streamingType)) {
            this.outstandingSubscriptionAcks.remove(streamingType);
            this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.ack(streamingType, true, this.connectionCorrelationId), self);
            this.logger.debug("Subscribed to Cluster <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
        } else {
            this.logger.debug("Subscription already acked for type <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
        }
    }

    private void confirmUnsubscription(StreamingType streamingType, ActorRef self) {
        this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.ack(streamingType, false, this.connectionCorrelationId), self);
        this.logger.debug("Unsubscribed from Cluster <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
    }

    private static Optional<DittoHeaderInvalidException> checkForAcksWithoutResponse(Signal<?> signal) {
        DittoHeaders dittoHeaders = signal.getDittoHeaders();
        if (!dittoHeaders.isResponseRequired() && !dittoHeaders.getAcknowledgementRequests().isEmpty()) {
            String message = String.format("For websocket, it is forbidden to request acknowledgements while '%s' is set to false.", DittoHeaderDefinition.RESPONSE_REQUIRED.getKey());
            String description = String.format("Please set '%s' to [] or '%s' to true.", DittoHeaderDefinition.REQUESTED_ACKS.getKey(), DittoHeaderDefinition.RESPONSE_REQUIRED.getKey());
            return Optional.of((DittoHeaderInvalidException)DittoHeaderInvalidException.newCustomMessageBuilder((String)message).description(description).dittoHeaders(signal.getDittoHeaders()).build());
        }
        return Optional.empty();
    }

    private static final class ConfirmUnsubscription
    extends WithStreamingType {
        private ConfirmUnsubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static final class ConfirmSubscription
    extends WithStreamingType {
        private ConfirmSubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static abstract class WithStreamingType {
        private final StreamingType streamingType;

        private WithStreamingType(StreamingType streamingType) {
            this.streamingType = streamingType;
        }

        StreamingType getStreamingType() {
            return this.streamingType;
        }
    }
}

