/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.japi.pf.ReceiveBuilder;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.namespaces.NamespaceReader;
import org.eclipse.ditto.model.query.criteria.Criteria;
import org.eclipse.ditto.model.query.criteria.CriteriaFactory;
import org.eclipse.ditto.model.query.criteria.CriteriaFactoryImpl;
import org.eclipse.ditto.model.query.expression.ThingsFieldExpressionFactory;
import org.eclipse.ditto.model.query.filter.QueryFilterCriteriaFactory;
import org.eclipse.ditto.model.query.things.ModelBasedThingsFieldExpressionFactory;
import org.eclipse.ditto.protocoladapter.TopicPath;
import org.eclipse.ditto.services.gateway.streaming.CloseStreamExceptionally;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.InvalidJwt;
import org.eclipse.ditto.services.gateway.streaming.RefreshSession;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedJsonifiable;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSession;
import org.eclipse.ditto.services.models.concierge.pubsub.DittoProtocolSub;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;
import org.eclipse.ditto.services.utils.akka.logging.DittoDiagnosticLoggingAdapter;
import org.eclipse.ditto.services.utils.akka.logging.DittoLoggerFactory;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.base.WithId;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.base.exceptions.GatewayWebsocketSessionClosedException;
import org.eclipse.ditto.signals.commands.base.exceptions.GatewayWebsocketSessionExpiredException;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.events.base.Event;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

final class StreamingSessionActor
extends AbstractActor {
    private final JsonSchemaVersion jsonSchemaVersion;
    private final String connectionCorrelationId;
    private final String type;
    private final DittoProtocolSub dittoProtocolSub;
    private final ActorRef eventAndResponsePublisher;
    private final Set<StreamingType> outstandingSubscriptionAcks;
    private final Map<StreamingType, StreamingSession> streamingSessions;
    private final DittoDiagnosticLoggingAdapter logger;
    @Nullable
    private Cancellable sessionTerminationCancellable;
    private AuthorizationContext authorizationContext;

    private StreamingSessionActor(Connect connect, DittoProtocolSub dittoProtocolSub, ActorRef eventAndResponsePublisher) {
        this.jsonSchemaVersion = connect.getJsonSchemaVersion();
        this.connectionCorrelationId = connect.getConnectionCorrelationId();
        this.type = connect.getType();
        this.dittoProtocolSub = dittoProtocolSub;
        this.eventAndResponsePublisher = eventAndResponsePublisher;
        this.outstandingSubscriptionAcks = EnumSet.noneOf(StreamingType.class);
        this.authorizationContext = AuthorizationModelFactory.emptyAuthContext();
        this.streamingSessions = new EnumMap<StreamingType, StreamingSession>(StreamingType.class);
        this.logger = DittoLoggerFactory.getDiagnosticLoggingAdapter((Actor)this);
        this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
        connect.getSessionExpirationTime().ifPresent(expiration -> {
            this.sessionTerminationCancellable = this.startSessionTimeout((Instant)expiration);
        });
        this.getContext().watch(eventAndResponsePublisher);
    }

    static Props props(Connect connect, DittoProtocolSub dittoProtocolSub, ActorRef eventAndResponsePublisher) {
        return Props.create(StreamingSessionActor.class, (Object[])new Object[]{connect, dittoProtocolSub, eventAndResponsePublisher});
    }

    public void postStop() {
        this.cancelSessionTimeout();
        this.logger.info("Closing <{}> streaming session.", (Object)this.type);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(CommandResponse.class, response -> {
            this.logger.withCorrelationId((WithDittoHeaders)response).debug("Got 'CommandResponse' message in <{}> session, telling EventAndResponsePublisher about it: {}", (Object)this.type, response);
            this.eventAndResponsePublisher.forward((Object)SessionedJsonifiable.response(response), (ActorContext)this.getContext());
        }).match(Signal.class, this::handleSignal).match(DittoRuntimeException.class, cre -> {
            this.logger.withCorrelationId((WithDittoHeaders)cre).info("Got 'DittoRuntimeException' message in <{}> session, telling EventAndResponsePublisher about it: {}", (Object)this.type, (Object)cre);
            this.eventAndResponsePublisher.forward((Object)SessionedJsonifiable.error(cre), (ActorContext)this.getContext());
        }).match(StartStreaming.class, startStreaming -> {
            Criteria criteria;
            this.authorizationContext = startStreaming.getAuthorizationContext();
            this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
            try {
                criteria = startStreaming.getFilter().map(f -> StreamingSessionActor.parseCriteria(f, DittoHeaders.newBuilder().correlationId((CharSequence)startStreaming.getConnectionCorrelationId()).build())).orElse(null);
            }
            catch (DittoRuntimeException e) {
                this.logger.info("Got 'DittoRuntimeException' <{}> session during 'StartStreaming' processing: {}: <{}>", (Object)this.type, (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
                this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.error(e), this.getSelf());
                return;
            }
            StreamingSession session = StreamingSession.of(startStreaming.getNamespaces(), criteria, startStreaming.getExtraFields().orElse(null));
            this.streamingSessions.put(startStreaming.getStreamingType(), session);
            this.logger.debug("Got 'StartStreaming' message in <{}> session, subscribing for <{}> in Cluster ...", (Object)this.type, (Object)startStreaming.getStreamingType().name());
            this.outstandingSubscriptionAcks.add(startStreaming.getStreamingType());
            AcknowledgeSubscription subscribeAck = new AcknowledgeSubscription(startStreaming.getStreamingType());
            Set<StreamingType> currentStreamingTypes = this.streamingSessions.keySet();
            this.dittoProtocolSub.subscribe(currentStreamingTypes, (Collection)this.authorizationContext.getAuthorizationSubjectIds(), this.getSelf()).thenAccept(ack -> this.getSelf().tell((Object)subscribeAck, this.getSelf()));
        }).match(StopStreaming.class, stopStreaming -> {
            this.logger.debug("Got 'StopStreaming' message in <{}> session, unsubscribing from <{}> in Cluster ...", (Object)this.type, (Object)stopStreaming.getStreamingType().name());
            this.streamingSessions.remove(stopStreaming.getStreamingType());
            AcknowledgeUnsubscription unsubscribeAck = new AcknowledgeUnsubscription(stopStreaming.getStreamingType());
            Set<StreamingType> currentStreamingTypes = this.streamingSessions.keySet();
            if (stopStreaming.getStreamingType() != StreamingType.EVENTS) {
                this.dittoProtocolSub.updateLiveSubscriptions(currentStreamingTypes, (Collection)this.authorizationContext.getAuthorizationSubjectIds(), this.getSelf()).thenAccept(ack -> this.getSelf().tell((Object)unsubscribeAck, this.getSelf()));
            } else {
                this.dittoProtocolSub.removeTwinSubscriber(this.getSelf(), (Collection)this.authorizationContext.getAuthorizationSubjectIds()).thenAccept(ack -> this.getSelf().tell((Object)unsubscribeAck, this.getSelf()));
            }
        }).match(RefreshSession.class, refreshSession -> {
            this.cancelSessionTimeout();
            this.checkAuthorizationContextAndStartSessionTimer((RefreshSession)refreshSession);
        }).match(InvalidJwt.class, invalidJwtToken -> this.cancelSessionTimeout()).match(AcknowledgeSubscription.class, msg -> this.acknowledgeSubscription(msg.getStreamingType(), this.getSelf())).match(AcknowledgeUnsubscription.class, msg -> this.acknowledgeUnsubscription(msg.getStreamingType(), this.getSelf())).match(Terminated.class, terminated -> {
            this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
            this.logger.debug("EventAndResponsePublisher was terminated.");
            this.logger.info("<{}> connection was closed, unsubscribing from Streams in Cluster ...", (Object)this.type);
            this.dittoProtocolSub.removeSubscriber(this.getSelf());
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.SECONDS), this.getSelf(), (Object)PoisonPill.getInstance(), (ExecutionContext)this.getContext().dispatcher(), this.getSelf());
        }).matchAny(any -> this.logger.withCorrelationId((CharSequence)this.connectionCorrelationId).warning("Got unknown message in '{}' session: '{}'", (Object)this.type, any)).build();
    }

    private void handleSignal(Signal<?> signal) {
        this.logger.setCorrelationId(signal);
        DittoHeaders dittoHeaders = signal.getDittoHeaders();
        if (this.connectionCorrelationId.equals(dittoHeaders.getOrigin().orElse(null))) {
            this.logger.debug("Got Signal <{}> in <{}> session, but this was issued by this connection itself, not telling EventAndResponsePublisher about it", (Object)signal.getType(), (Object)this.type);
        } else {
            StreamingSession session = this.streamingSessions.get(StreamingSessionActor.determineStreamingType(signal));
            if (null != session && this.isSessionAllowedToReceiveSignal(signal, session)) {
                this.logger.debug("Got Signal <{}> in <{}> session, telling EventAndResponsePublisher about it: {}", (Object)signal.getType(), (Object)this.type, signal);
                DittoHeaders sessionHeaders = DittoHeaders.newBuilder().authorizationContext(this.authorizationContext).schemaVersion(this.jsonSchemaVersion).build();
                SessionedJsonifiable sessionedJsonifiable = SessionedJsonifiable.signal(signal, sessionHeaders, session);
                this.eventAndResponsePublisher.tell((Object)sessionedJsonifiable, this.getSelf());
            }
        }
        this.logger.setCorrelationId((CharSequence)this.connectionCorrelationId);
    }

    private boolean isSessionAllowedToReceiveSignal(Signal<?> signal, StreamingSession session) {
        DittoHeaders headers = signal.getDittoHeaders();
        boolean isAuthorizedToRead = this.authorizationContext.isAuthorized((Collection)headers.getReadGrantedSubjects(), (Collection)headers.getReadRevokedSubjects());
        boolean matchesNamespace = this.matchesNamespaces(signal, session);
        return isAuthorizedToRead && matchesNamespace;
    }

    private Cancellable startSessionTimeout(Instant sessionExpirationTime) {
        long timeout = sessionExpirationTime.minusMillis(Instant.now().toEpochMilli()).toEpochMilli();
        this.logger.debug("Starting session timeout - session will expire in {} ms", (Object)timeout);
        FiniteDuration sessionExpirationTimeMillis = FiniteDuration.apply((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        return this.getContext().getSystem().getScheduler().scheduleOnce(sessionExpirationTimeMillis, this::handleSessionTimeout, (ExecutionContext)this.getContext().getDispatcher());
    }

    private void handleSessionTimeout() {
        this.logger.info("Stopping WebSocket session for connection with ID <{}>.", (Object)this.connectionCorrelationId);
        GatewayWebsocketSessionExpiredException gatewayWebsocketSessionExpiredException = (GatewayWebsocketSessionExpiredException)GatewayWebsocketSessionExpiredException.newBuilder().dittoHeaders(DittoHeaders.newBuilder().correlationId((CharSequence)this.connectionCorrelationId).build()).build();
        this.eventAndResponsePublisher.tell((Object)CloseStreamExceptionally.getInstance((DittoRuntimeException)gatewayWebsocketSessionExpiredException, this.connectionCorrelationId), this.getSelf());
    }

    private void cancelSessionTimeout() {
        if (null != this.sessionTerminationCancellable) {
            this.sessionTerminationCancellable.cancel();
        }
    }

    private void checkAuthorizationContextAndStartSessionTimer(RefreshSession refreshSession) {
        AuthorizationContext newAuthorizationContext = refreshSession.getAuthorizationContext();
        if (!this.authorizationContext.equals(newAuthorizationContext)) {
            this.logger.debug("Authorization Context changed for WebSocket session <{}>. Terminating the session.", (Object)this.connectionCorrelationId);
            GatewayWebsocketSessionClosedException gatewayWebsocketSessionClosedException = (GatewayWebsocketSessionClosedException)GatewayWebsocketSessionClosedException.newBuilder().dittoHeaders(DittoHeaders.newBuilder().correlationId((CharSequence)this.connectionCorrelationId).build()).build();
            this.eventAndResponsePublisher.tell((Object)CloseStreamExceptionally.getInstance((DittoRuntimeException)gatewayWebsocketSessionClosedException, this.connectionCorrelationId), this.getSelf());
        } else {
            this.sessionTerminationCancellable = this.startSessionTimeout(refreshSession.getSessionTimeout());
        }
    }

    private boolean matchesNamespaces(Signal<?> signal, StreamingSession session) {
        boolean result;
        List<String> namespaces = session.getNamespaces();
        boolean bl = result = namespaces.isEmpty() || namespaces.contains(StreamingSessionActor.namespaceFromId(signal));
        if (!result) {
            this.logger.debug("Signal does not match namespaces.");
        }
        return result;
    }

    private static StreamingType determineStreamingType(Signal<?> signal) {
        String channel = signal.getDittoHeaders().getChannel().orElse(TopicPath.Channel.TWIN.getName());
        StreamingType streamingType = signal instanceof Event ? (channel.equals(TopicPath.Channel.TWIN.getName()) ? StreamingType.EVENTS : StreamingType.LIVE_EVENTS) : (signal instanceof MessageCommand ? StreamingType.MESSAGES : StreamingType.LIVE_COMMANDS);
        return streamingType;
    }

    @Nullable
    private static String namespaceFromId(WithId withId) {
        return NamespaceReader.fromEntityId((EntityId)withId.getEntityId()).orElse(null);
    }

    private static Criteria parseCriteria(String filter, DittoHeaders dittoHeaders) {
        CriteriaFactoryImpl criteriaFactory = new CriteriaFactoryImpl();
        ModelBasedThingsFieldExpressionFactory fieldExpressionFactory = new ModelBasedThingsFieldExpressionFactory();
        QueryFilterCriteriaFactory queryFilterCriteriaFactory = new QueryFilterCriteriaFactory((CriteriaFactory)criteriaFactory, (ThingsFieldExpressionFactory)fieldExpressionFactory);
        return queryFilterCriteriaFactory.filterCriteria(filter, dittoHeaders);
    }

    private void acknowledgeSubscription(StreamingType streamingType, ActorRef self) {
        if (this.outstandingSubscriptionAcks.contains(streamingType)) {
            this.outstandingSubscriptionAcks.remove(streamingType);
            this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.ack(streamingType, true, this.connectionCorrelationId), self);
            this.logger.debug("Subscribed to Cluster <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
        } else {
            this.logger.debug("Subscription already acked for type <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
        }
    }

    private void acknowledgeUnsubscription(StreamingType streamingType, ActorRef self) {
        this.eventAndResponsePublisher.tell((Object)SessionedJsonifiable.ack(streamingType, false, this.connectionCorrelationId), self);
        this.logger.debug("Unsubscribed from Cluster <{}> in <{}> session.", (Object)streamingType, (Object)this.type);
    }

    private static final class AcknowledgeUnsubscription
    extends WithStreamingType {
        private AcknowledgeUnsubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static final class AcknowledgeSubscription
    extends WithStreamingType {
        private AcknowledgeSubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static abstract class WithStreamingType {
        private final StreamingType streamingType;

        private WithStreamingType(StreamingType streamingType) {
            this.streamingType = streamingType;
        }

        StreamingType getStreamingType() {
            return this.streamingType;
        }
    }
}

