/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.services.gateway.streaming.StreamingAck;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedResponseErrorOrAck;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedSignal;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSession;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;
import org.eclipse.ditto.services.models.signalenrichment.SignalEnrichmentFacade;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.commands.base.CommandResponse;

public interface SessionedJsonifiable {
    public Jsonifiable.WithPredicate<JsonObject, JsonField> getJsonifiable();

    public DittoHeaders getDittoHeaders();

    public CompletionStage<JsonObject> retrieveExtraFields(@Nullable SignalEnrichmentFacade var1);

    public Optional<StreamingSession> getSession();

    public static SessionedJsonifiable signal(Signal<?> signal, DittoHeaders sessionHeaders, StreamingSession session) {
        return new SessionedSignal(signal, sessionHeaders, session);
    }

    public static SessionedJsonifiable error(DittoRuntimeException error) {
        return new SessionedResponseErrorOrAck((Jsonifiable.WithPredicate<JsonObject, JsonField>)error, error.getDittoHeaders());
    }

    public static SessionedJsonifiable response(CommandResponse<?> response) {
        return new SessionedResponseErrorOrAck((Jsonifiable.WithPredicate<JsonObject, JsonField>)response, response.getDittoHeaders());
    }

    public static SessionedJsonifiable ack(StreamingType streamingType, boolean subscribed, String connectionCorrelationId) {
        return new SessionedResponseErrorOrAck(new StreamingAck(streamingType, subscribed), DittoHeaders.newBuilder().correlationId((CharSequence)connectionCorrelationId).build());
    }
}

