/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.time.Duration;
import java.util.HashMap;
import org.eclipse.ditto.services.base.config.SignalEnrichmentConfig;
import org.eclipse.ditto.services.gateway.streaming.WebsocketConfig;
import org.eclipse.ditto.services.utils.config.KnownConfigValue;

public interface StreamingConfig {
    public static final String CONFIG_PATH = "streaming";

    public Duration getSessionCounterScrapeInterval();

    public WebsocketConfig getWebsocketConfig();

    public SignalEnrichmentConfig getSignalEnrichmentConfig();

    public int getParallelism();

    default public Config render() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(StreamingConfigValue.SESSION_COUNTER_SCRAPE_INTERVAL.getConfigPath(), this.getSessionCounterScrapeInterval().toMillis() + "ms");
        map.put(StreamingConfigValue.PARALLELISM.getConfigPath(), this.getParallelism());
        return ConfigFactory.parseMap(map).withFallback((ConfigMergeable)this.getWebsocketConfig().render()).withFallback((ConfigMergeable)this.getSignalEnrichmentConfig().render()).atKey(CONFIG_PATH);
    }

    public static enum StreamingConfigValue implements KnownConfigValue
    {
        SESSION_COUNTER_SCRAPE_INTERVAL("session-counter-scrape-interval", Duration.ofSeconds(30L)),
        PARALLELISM("parallelism", 64);

        private final String path;
        private final Object defaultValue;

        private StreamingConfigValue(String thePath, Object theDefaultValue) {
            this.path = thePath;
            this.defaultValue = theDefaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getConfigPath() {
            return this.path;
        }
    }
}

