/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.services.gateway.streaming.StreamControlMessage;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;

@Immutable
public final class StopStreaming
implements StreamControlMessage {
    private final StreamingType streamingType;
    private final String connectionCorrelationId;

    public StopStreaming(StreamingType streamingType, String connectionCorrelationId) {
        this.streamingType = (StreamingType)ConditionChecker.checkNotNull((Object)streamingType, (String)"streamingType");
        this.connectionCorrelationId = (String)ConditionChecker.checkNotNull((Object)connectionCorrelationId, (String)"connectionCorrelationId");
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopStreaming that = (StopStreaming)o;
        return this.streamingType == that.streamingType && Objects.equals(this.connectionCorrelationId, that.connectionCorrelationId);
    }

    public int hashCode() {
        return Objects.hash(this.streamingType, this.connectionCorrelationId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingType=" + this.streamingType + ", connectionCorrelationId=" + this.connectionCorrelationId + "]";
    }
}

