/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.event.DiagnosticLoggingAdapter;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.jwt.ImmutableJsonWebToken;
import org.eclipse.ditto.model.jwt.JsonWebToken;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthenticationFactory;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthorizationContextProvider;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtValidator;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.DefaultStreamingConfig;
import org.eclipse.ditto.services.gateway.streaming.InvalidJwtToken;
import org.eclipse.ditto.services.gateway.streaming.JwtToken;
import org.eclipse.ditto.services.gateway.streaming.RefreshSession;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.StreamingConfig;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSessionActor;
import org.eclipse.ditto.services.models.concierge.pubsub.DittoProtocolSub;
import org.eclipse.ditto.services.utils.akka.LogUtil;
import org.eclipse.ditto.services.utils.akka.actors.ModifyConfigBehavior;
import org.eclipse.ditto.services.utils.akka.actors.RetrieveConfigBehavior;
import org.eclipse.ditto.services.utils.metrics.DittoMetrics;
import org.eclipse.ditto.services.utils.metrics.instruments.gauge.Gauge;
import org.eclipse.ditto.signals.base.Signal;

public final class StreamingActor
extends AbstractActorWithTimers
implements RetrieveConfigBehavior,
ModifyConfigBehavior {
    public static final String ACTOR_NAME = "streaming";
    private final DiagnosticLoggingAdapter logger = LogUtil.obtain((Actor)this);
    private final DittoProtocolSub dittoProtocolSub;
    private final ActorRef commandRouter;
    private final Gauge streamingSessionsCounter;
    private final JwtValidator jwtValidator;
    private final JwtAuthorizationContextProvider jwtAuthorizationContextProvider;
    private final SupervisorStrategy strategy = new OneForOneStrategy(true, DeciderBuilder.match(Throwable.class, e -> {
        this.logger.error(e, "Escalating above actor!");
        return SupervisorStrategy.escalate();
    }).matchAny(e -> {
        this.logger.error("Unknown message:'{}'! Escalating above actor!", e);
        return SupervisorStrategy.escalate();
    }).build());
    private StreamingConfig streamingConfig;

    private StreamingActor(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig) {
        this.dittoProtocolSub = dittoProtocolSub;
        this.commandRouter = commandRouter;
        this.streamingConfig = streamingConfig;
        this.streamingSessionsCounter = DittoMetrics.gauge((String)"streaming_sessions_count");
        this.jwtValidator = jwtAuthenticationFactory.getJwtValidator();
        this.jwtAuthorizationContextProvider = jwtAuthenticationFactory.newJwtAuthorizationContextProvider();
        this.scheduleScrapeStreamSessionsCounter();
    }

    public static Props props(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig) {
        return Props.create(StreamingActor.class, (Object[])new Object[]{dittoProtocolSub, commandRouter, jwtAuthenticationFactory, streamingConfig});
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.strategy;
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(Connect.class, connect -> {
            ActorRef eventAndResponsePublisher = connect.getEventAndResponsePublisher();
            eventAndResponsePublisher.forward(connect, (ActorContext)this.getContext());
            String connectionCorrelationId = connect.getConnectionCorrelationId();
            this.getContext().actorOf(StreamingSessionActor.props(connectionCorrelationId, connect.getType(), this.dittoProtocolSub, eventAndResponsePublisher, connect.getSessionExpirationTime()), connectionCorrelationId);
        }).match(StartStreaming.class, startStreaming -> this.forwardToSessionActor(startStreaming.getConnectionCorrelationId(), startStreaming)).match(StopStreaming.class, stopStreaming -> this.forwardToSessionActor(stopStreaming.getConnectionCorrelationId(), stopStreaming)).match(JwtToken.class, this::refreshWebsocketSession).build().orElse(this.retrieveConfigBehavior()).orElse(this.modifyConfigBehavior()).orElse(ReceiveBuilder.create().match(Signal.class, signal -> {
            Optional originOpt = signal.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                String origin = (String)originOpt.get();
                Optional sessionActor = this.getContext().findChild(origin);
                if (sessionActor.isPresent()) {
                    this.commandRouter.tell(signal, (ActorRef)sessionActor.get());
                } else {
                    this.logger.debug("No session actor found for origin: {}", (Object)origin);
                }
            } else {
                this.logger.warning("Signal is missing the required origin header: {}", (Object)signal.getDittoHeaders().getCorrelationId());
            }
        }).matchEquals((Object)Control.RETRIEVE_WEBSOCKET_CONFIG, this::replyWebsocketConfig).matchEquals((Object)Control.SCRAPE_STREAM_COUNTER, this::updateStreamingSessionsCounter).match(DittoRuntimeException.class, cre -> {
            Optional originOpt = cre.getDittoHeaders().getOrigin();
            if (originOpt.isPresent()) {
                this.forwardToSessionActor((String)originOpt.get(), cre);
            } else {
                this.logger.warning("Unhandled DittoRuntimeException: <{}: {}>", (Object)cre.getClass().getSimpleName(), (Object)cre.getMessage());
            }
        }).matchAny(any -> this.logger.warning("Got unknown message: '{}'", any)).build());
    }

    public Config getConfig() {
        return this.streamingConfig.render().getConfig(ACTOR_NAME);
    }

    public Config setConfig(Config config) {
        this.streamingConfig = DefaultStreamingConfig.of(config.atKey(ACTOR_NAME).withFallback((ConfigMergeable)this.streamingConfig.render()));
        this.scheduleScrapeStreamSessionsCounter();
        return this.streamingConfig.render();
    }

    private void refreshWebsocketSession(JwtToken jwtToken) {
        String connectionCorrelationId = jwtToken.getConnectionCorrelationId();
        JsonWebToken jsonWebToken = ImmutableJsonWebToken.fromToken((String)jwtToken.getJwtTokenAsString());
        this.jwtValidator.validate(jsonWebToken).thenAccept(binaryValidationResult -> {
            if (binaryValidationResult.isValid()) {
                AuthorizationContext authorizationContext = this.jwtAuthorizationContextProvider.getAuthorizationContext(jsonWebToken);
                this.forwardToSessionActor(connectionCorrelationId, new RefreshSession(connectionCorrelationId, jsonWebToken.getExpirationTime(), authorizationContext));
            }
            String reasonForInvalidity = binaryValidationResult.getReasonForInvalidity().getMessage();
            this.forwardToSessionActor(connectionCorrelationId, new InvalidJwtToken(connectionCorrelationId, reasonForInvalidity));
        });
    }

    private void forwardToSessionActor(String connectionCorrelationId, Object object) {
        if (object instanceof WithDittoHeaders) {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)((WithDittoHeaders)object), (LogUtil.MdcField[])new LogUtil.MdcField[0]);
        } else {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (String)null, (LogUtil.MdcField[])new LogUtil.MdcField[0]);
        }
        this.logger.debug("Forwarding to session actor '{}': {}", (Object)connectionCorrelationId, object);
        this.getContext().actorSelection(connectionCorrelationId).forward(object, (ActorContext)this.getContext());
    }

    private void scheduleScrapeStreamSessionsCounter() {
        this.getTimers().startPeriodicTimer((Object)Control.SCRAPE_STREAM_COUNTER, (Object)Control.SCRAPE_STREAM_COUNTER, this.streamingConfig.getSessionCounterScrapeInterval());
    }

    private void replyWebsocketConfig(Control trigger) {
        this.getSender().tell((Object)this.streamingConfig.getWebsocketConfig(), this.getSelf());
    }

    private void updateStreamingSessionsCounter(Control trigger) {
        if (this.getContext() != null) {
            this.streamingSessionsCounter.set(Long.valueOf(StreamSupport.stream(this.getContext().getChildren().spliterator(), false).count()));
        }
    }

    public static enum Control {
        SCRAPE_STREAM_COUNTER,
        RETRIEVE_WEBSOCKET_CONFIG;

    }
}

