/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.DiagnosticLoggingAdapter;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.query.criteria.Criteria;
import org.eclipse.ditto.model.query.criteria.CriteriaFactory;
import org.eclipse.ditto.model.query.criteria.CriteriaFactoryImpl;
import org.eclipse.ditto.model.query.expression.ThingsFieldExpressionFactory;
import org.eclipse.ditto.model.query.filter.QueryFilterCriteriaFactory;
import org.eclipse.ditto.model.query.things.ModelBasedThingsFieldExpressionFactory;
import org.eclipse.ditto.model.query.things.ThingPredicateVisitor;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.protocoladapter.TopicPath;
import org.eclipse.ditto.services.gateway.streaming.StartStreaming;
import org.eclipse.ditto.services.gateway.streaming.StopStreaming;
import org.eclipse.ditto.services.gateway.streaming.StreamingAck;
import org.eclipse.ditto.services.models.concierge.streaming.StreamingType;
import org.eclipse.ditto.services.utils.akka.LogUtil;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.base.WithId;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.events.base.Event;
import org.eclipse.ditto.signals.events.things.ThingEvent;
import org.eclipse.ditto.signals.events.things.ThingEventToThingConverter;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

final class StreamingSessionActor
extends AbstractActor {
    private static final int MAX_SUBSCRIBE_TIMEOUT_MS = 5000;
    private final DiagnosticLoggingAdapter logger = LogUtil.obtain((Actor)this);
    private final String connectionCorrelationId;
    private final String type;
    private final ActorRef pubSubMediator;
    private final ActorRef eventAndResponsePublisher;
    private final Set<StreamingType> outstandingSubscriptionAcks;
    private List<String> authorizationSubjects;
    private Map<StreamingType, List<String>> namespacesForStreamingTypes;
    private Map<StreamingType, Criteria> eventFilterCriteriaForStreamingTypes;

    private StreamingSessionActor(String connectionCorrelationId, String type, ActorRef pubSubMediator, ActorRef eventAndResponsePublisher) {
        this.connectionCorrelationId = connectionCorrelationId;
        this.type = type;
        this.pubSubMediator = pubSubMediator;
        this.eventAndResponsePublisher = eventAndResponsePublisher;
        this.outstandingSubscriptionAcks = new HashSet<StreamingType>();
        this.namespacesForStreamingTypes = new EnumMap<StreamingType, List<String>>(StreamingType.class);
        this.eventFilterCriteriaForStreamingTypes = new EnumMap<StreamingType, Criteria>(StreamingType.class);
        this.getContext().watch(eventAndResponsePublisher);
    }

    static Props props(final String connectionCorrelationId, final String type, final ActorRef pubSubMediator, final ActorRef eventAndResponsePublisher) {
        return Props.create(StreamingSessionActor.class, (Creator)new Creator<StreamingSessionActor>(){
            private static final long serialVersionUID = 1L;

            public StreamingSessionActor create() throws Exception {
                return new StreamingSessionActor(connectionCorrelationId, type, pubSubMediator, eventAndResponsePublisher);
            }
        });
    }

    public void postStop() throws Exception {
        LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
        this.logger.info("Closing '{}' streaming session: {}", (Object)this.type, (Object)this.connectionCorrelationId);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(CommandResponse.class, response -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)response);
            this.logger.debug("Got 'CommandResponse' message in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)this.type, response);
            this.eventAndResponsePublisher.forward(response, (ActorContext)this.getContext());
        }).match(Signal.class, this::handleSignal).match(DittoRuntimeException.class, cre -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (WithDittoHeaders)cre);
            this.logger.info("Got 'DittoRuntimeException' message in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)this.type, (Object)cre);
            this.eventAndResponsePublisher.forward((Object)cre, (ActorContext)this.getContext());
        }).match(StartStreaming.class, startStreaming -> {
            this.authorizationSubjects = startStreaming.getAuthorizationContext().getAuthorizationSubjectIds();
            this.namespacesForStreamingTypes.put(startStreaming.getStreamingType(), startStreaming.getNamespaces());
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            try {
                this.eventFilterCriteriaForStreamingTypes.put(startStreaming.getStreamingType(), startStreaming.getFilter().map(f -> this.parseCriteria((String)f, DittoHeaders.newBuilder().correlationId((CharSequence)startStreaming.getConnectionCorrelationId()).build())).orElse(null));
            }
            catch (DittoRuntimeException e) {
                this.logger.info("Got 'DittoRuntimeException' <{}> session during 'StartStreaming' processing: {}: <{}>", (Object)this.type, (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
                this.eventAndResponsePublisher.tell((Object)e, this.getSelf());
                return;
            }
            this.logger.debug("Got 'StartStreaming' message in <{}> session, subscribing for <{}> in Cluster..", (Object)this.type, (Object)startStreaming.getStreamingType().name());
            this.outstandingSubscriptionAcks.add(startStreaming.getStreamingType());
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(startStreaming.getStreamingType().getDistributedPubSubTopic(), this.connectionCorrelationId, this.getSelf()), this.getSelf());
        }).match(StopStreaming.class, stopStreaming -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            this.logger.debug("Got 'StopStreaming' message in <{}> session, unsubscribing from <{}> in Cluster..", (Object)this.type, (Object)stopStreaming.getStreamingType().name());
            this.namespacesForStreamingTypes.remove(stopStreaming.getStreamingType());
            this.eventFilterCriteriaForStreamingTypes.remove(stopStreaming.getStreamingType());
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(stopStreaming.getStreamingType().getDistributedPubSubTopic(), this.connectionCorrelationId, this.getSelf()), this.getSelf());
        }).match(DistributedPubSubMediator.SubscribeAck.class, subscribeAck -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            String topic = subscribeAck.subscribe().topic();
            StreamingType streamingType = StreamingType.fromTopic((String)topic);
            ActorRef self = this.getSelf();
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS), self, (Object)new AcknowledgeSubscription(streamingType), (ExecutionContext)this.getContext().getSystem().dispatcher(), self);
        }).match(DistributedPubSubMediator.UnsubscribeAck.class, unsubscribeAck -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            String topic = unsubscribeAck.unsubscribe().topic();
            StreamingType streamingType = StreamingType.fromTopic((String)topic);
            ActorRef self = this.getSelf();
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS), self, (Object)new AcknowledgeUnsubscription(streamingType), (ExecutionContext)this.getContext().getSystem().dispatcher(), self);
        }).match(AcknowledgeSubscription.class, msg -> this.acknowledgeSubscription(msg.getStreamingType(), this.getSelf())).match(AcknowledgeUnsubscription.class, msg -> this.acknowledgeUnsubscription(msg.getStreamingType(), this.getSelf())).match(Terminated.class, terminated -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            this.logger.debug("eventAndResponsePublisher was terminated");
            this.logger.info("<{}> connection was closed, unsubscribing from Streams in Cluster..", (Object)this.type);
            Arrays.stream(StreamingType.values()).map(StreamingType::getDistributedPubSubTopic).forEach(topic -> this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(topic, this.connectionCorrelationId, this.getSelf()), this.getSelf()));
            this.getContext().getSystem().scheduler().scheduleOnce(FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.SECONDS), this.getSelf(), (Object)PoisonPill.getInstance(), (ExecutionContext)this.getContext().dispatcher(), this.getSelf());
        }).matchAny(any -> {
            LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, (CharSequence)this.connectionCorrelationId);
            this.logger.warning("Got unknown message in '{}' session: '{}'", (Object)this.type, any);
        }).build();
    }

    private void handleSignal(Signal<?> signal) {
        LogUtil.enhanceLogWithCorrelationId((DiagnosticLoggingAdapter)this.logger, signal);
        DittoHeaders dittoHeaders = signal.getDittoHeaders();
        if (this.connectionCorrelationId.equals(dittoHeaders.getOrigin().orElse(null))) {
            this.logger.debug("Got Signal <{}> in <{}> session, but this was issued by this connection itself, not telling eventAndResponsePublisher about it", (Object)signal.getType(), (Object)this.type);
        } else if (this.authorizationSubjects != null && !Collections.disjoint(dittoHeaders.getReadSubjects(), this.authorizationSubjects)) {
            if (this.matchesNamespaces(signal)) {
                if (this.matchesFilter(signal)) {
                    this.logger.debug("Got Signal <{}> in <{}> session, telling eventAndResponsePublisher about it: {}", (Object)signal.getType(), (Object)this.type, signal);
                    this.eventAndResponsePublisher.tell(signal, this.getSelf());
                } else {
                    this.logger.debug("Signal does not match filter");
                }
            } else {
                this.logger.debug("Signal does not match namespaces");
            }
        }
    }

    private boolean matchesNamespaces(Signal<?> signal) {
        StreamingType streamingType = StreamingSessionActor.determineStreamingType(signal);
        List namespaces = Optional.ofNullable(this.namespacesForStreamingTypes.get(streamingType)).orElse(Collections.emptyList());
        return namespaces.isEmpty() || namespaces.contains(StreamingSessionActor.namespaceFromId(signal));
    }

    private static StreamingType determineStreamingType(Signal<?> signal) {
        String channel = signal.getDittoHeaders().getChannel().orElse(TopicPath.Channel.TWIN.getName());
        StreamingType streamingType = signal instanceof Event ? (channel.equals(TopicPath.Channel.TWIN.getName()) ? StreamingType.EVENTS : StreamingType.LIVE_EVENTS) : (signal instanceof MessageCommand ? StreamingType.MESSAGES : StreamingType.LIVE_COMMANDS);
        return streamingType;
    }

    private static String namespaceFromId(WithId withId) {
        return withId.getId().split(":", 2)[0];
    }

    private Criteria parseCriteria(String filter, DittoHeaders dittoHeaders) {
        CriteriaFactoryImpl criteriaFactory = new CriteriaFactoryImpl();
        ModelBasedThingsFieldExpressionFactory fieldExpressionFactory = new ModelBasedThingsFieldExpressionFactory();
        QueryFilterCriteriaFactory queryFilterCriteriaFactory = new QueryFilterCriteriaFactory((CriteriaFactory)criteriaFactory, (ThingsFieldExpressionFactory)fieldExpressionFactory);
        return queryFilterCriteriaFactory.filterCriteria(filter, dittoHeaders);
    }

    private boolean matchesFilter(Signal<?> signal) {
        if (signal instanceof ThingEvent) {
            StreamingType streamingType = StreamingSessionActor.determineStreamingType(signal);
            return ThingEventToThingConverter.thingEventToThing((ThingEvent)((ThingEvent)signal)).filter(thing -> this.doMatchFilter(streamingType, (Thing)thing)).isPresent();
        }
        return true;
    }

    private boolean doMatchFilter(StreamingType streamingType, Thing thing) {
        Optional<Criteria> criteria = Optional.ofNullable(this.eventFilterCriteriaForStreamingTypes.get(streamingType));
        return criteria.map(c -> ThingPredicateVisitor.apply((Criteria)c).test(thing)).orElse(true);
    }

    private void acknowledgeSubscription(StreamingType streamingType, ActorRef self) {
        if (this.outstandingSubscriptionAcks.contains(streamingType)) {
            this.outstandingSubscriptionAcks.remove(streamingType);
            this.eventAndResponsePublisher.tell((Object)new StreamingAck(streamingType, true), self);
            this.logger.debug("Subscribed to Cluster <{}> in <{}> session", (Object)streamingType, (Object)this.type);
        } else {
            this.logger.debug("Subscription already acked for type <{}> in <{}> session", (Object)streamingType, (Object)this.type);
        }
    }

    private void acknowledgeUnsubscription(StreamingType streamingType, ActorRef self) {
        this.eventAndResponsePublisher.tell((Object)new StreamingAck(streamingType, false), self);
        this.logger.debug("Unsubscribed from Cluster <{}> in <{}> session", (Object)streamingType, (Object)this.type);
    }

    private static final class AcknowledgeUnsubscription
    extends WithStreamingType {
        private AcknowledgeUnsubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static final class AcknowledgeSubscription
    extends WithStreamingType {
        private AcknowledgeSubscription(StreamingType streamingType) {
            super(streamingType);
        }
    }

    private static abstract class WithStreamingType {
        private final StreamingType streamingType;

        private WithStreamingType(StreamingType streamingType) {
            this.streamingType = streamingType;
        }

        StreamingType getStreamingType() {
            return this.streamingType;
        }
    }
}

