/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Arrays;

public enum StreamingType {
    EVENTS("things.events:"),
    MESSAGES("messages.commands:"),
    LIVE_COMMANDS("things-live-commands"),
    LIVE_EVENTS("things-live-events");

    private final String distributedPubSubTopic;

    private StreamingType(String distributedPubSubTopic) {
        this.distributedPubSubTopic = distributedPubSubTopic;
    }

    public String getDistributedPubSubTopic() {
        return this.distributedPubSubTopic;
    }

    public static StreamingType fromTopic(String distributedPubSubTopic) {
        return Arrays.stream(StreamingType.values()).filter(header -> distributedPubSubTopic.equals(header.getDistributedPubSubTopic())).findFirst().orElseThrow(() -> new IllegalStateException("Unknown distributedPubSubTopic: " + distributedPubSubTopic));
    }
}

