/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import java.util.Objects;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.services.gateway.streaming.StreamingType;

public final class StartStreaming {
    private final StreamingType streamingType;
    private final String connectionCorrelationId;
    private final AuthorizationContext authorizationContext;

    public StartStreaming(StreamingType streamingType, String connectionCorrelationId, AuthorizationContext authorizationContext) {
        this.streamingType = streamingType;
        this.connectionCorrelationId = connectionCorrelationId;
        this.authorizationContext = authorizationContext;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartStreaming that = (StartStreaming)o;
        return this.streamingType == that.streamingType && Objects.equals(this.connectionCorrelationId, that.connectionCorrelationId) && Objects.equals(this.authorizationContext, that.authorizationContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.streamingType, this.connectionCorrelationId, this.authorizationContext});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [streamingType=" + (Object)((Object)this.streamingType) + ", connectionCorrelationId=" + this.connectionCorrelationId + ", authorizationContext=" + this.authorizationContext + "]";
    }
}

