/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.thingsearch.CursorOption;
import org.eclipse.ditto.model.thingsearch.ImmutableCursorOption;
import org.eclipse.ditto.model.thingsearch.ImmutableLimitOption;
import org.eclipse.ditto.model.thingsearch.ImmutableLogicalFilter;
import org.eclipse.ditto.model.thingsearch.ImmutableSearchProperty;
import org.eclipse.ditto.model.thingsearch.ImmutableSearchQueryBuilder;
import org.eclipse.ditto.model.thingsearch.ImmutableSearchResult;
import org.eclipse.ditto.model.thingsearch.ImmutableSearchResultBuilder;
import org.eclipse.ditto.model.thingsearch.ImmutableSizeOption;
import org.eclipse.ditto.model.thingsearch.ImmutableSortOption;
import org.eclipse.ditto.model.thingsearch.ImmutableSortOptionEntry;
import org.eclipse.ditto.model.thingsearch.LimitOption;
import org.eclipse.ditto.model.thingsearch.LogicalSearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchProperty;
import org.eclipse.ditto.model.thingsearch.SearchQuery;
import org.eclipse.ditto.model.thingsearch.SearchQueryBuilder;
import org.eclipse.ditto.model.thingsearch.SearchResult;
import org.eclipse.ditto.model.thingsearch.SearchResultBuilder;
import org.eclipse.ditto.model.thingsearch.SizeOption;
import org.eclipse.ditto.model.thingsearch.SortOption;
import org.eclipse.ditto.model.thingsearch.SortOptionEntry;

@Immutable
public final class SearchModelFactory {
    private SearchModelFactory() {
        throw new AssertionError();
    }

    public static SearchResult newSearchResult(JsonArray items, long nextPageOffset) {
        return ImmutableSearchResult.of(items, nextPageOffset, null);
    }

    public static SearchResult emptySearchResult() {
        return ImmutableSearchResult.empty();
    }

    public static SearchResult newSearchResult(JsonObject jsonObject) {
        return (SearchResult)DittoJsonException.wrapJsonRuntimeException(() -> ImmutableSearchResult.fromJson(jsonObject));
    }

    public static SearchResult newSearchResult(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return SearchModelFactory.newSearchResult(jsonObject);
    }

    public static SearchResultBuilder newSearchResultBuilder() {
        return ImmutableSearchResultBuilder.newInstance();
    }

    public static SearchResultBuilder newSearchResultBuilder(SearchResult searchResult) {
        return ImmutableSearchResultBuilder.of(searchResult);
    }

    public static LogicalSearchFilter and(SearchFilter filter1, SearchFilter filter2, SearchFilter ... furtherFilters) {
        return ImmutableLogicalFilter.and(filter1, filter2, furtherFilters);
    }

    public static LogicalSearchFilter or(SearchFilter filter1, SearchFilter filter2, SearchFilter ... furtherFilters) {
        return ImmutableLogicalFilter.or(filter1, filter2, furtherFilters);
    }

    public static LogicalSearchFilter not(SearchFilter filter) {
        return ImmutableLogicalFilter.not(filter);
    }

    public static SearchProperty property(JsonPointer propertyPath) {
        return ImmutableSearchProperty.of(propertyPath);
    }

    public static SearchProperty property(CharSequence propertyPath) {
        return SearchModelFactory.property(JsonFactory.newPointer((CharSequence)propertyPath));
    }

    public static SearchQuery newSearchQuery(SearchFilter filter) {
        return SearchModelFactory.newSearchQueryBuilder(filter).build();
    }

    public static SearchQueryBuilder newSearchQueryBuilder(SearchFilter filter) {
        return ImmutableSearchQueryBuilder.of(filter);
    }

    public static SortOption newSortOption(List<SortOptionEntry> sortOptionEntries) {
        return ImmutableSortOption.of(sortOptionEntries);
    }

    public static SortOption newSortOption(CharSequence propertyPath, SortOptionEntry.SortOrder sortOrder) {
        Objects.requireNonNull(sortOrder);
        Objects.requireNonNull(propertyPath);
        ImmutableSortOptionEntry entry = ImmutableSortOptionEntry.of(propertyPath, sortOrder);
        return ImmutableSortOption.of(Collections.singletonList(entry));
    }

    @Deprecated
    public static SortOptionEntry newSortOptionEntry(SortOptionEntry.SortOrder sortOrder, CharSequence propertyPath) {
        return SearchModelFactory.newSortOptionEntry(propertyPath, sortOrder);
    }

    public static SortOptionEntry newSortOptionEntry(CharSequence propertyPath, SortOptionEntry.SortOrder sortOrder) {
        return ImmutableSortOptionEntry.of(propertyPath, sortOrder);
    }

    public static LimitOption newLimitOption(int offset, int count) {
        return ImmutableLimitOption.of(offset, count);
    }

    public static SizeOption newSizeOption(int size) {
        return ImmutableSizeOption.of(size);
    }

    public static CursorOption newCursorOption(String cursor) {
        return ImmutableCursorOption.of((String)ConditionChecker.checkNotNull((Object)cursor, (String)"cursor"));
    }
}

