/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.ImmutableLimitOption;
import org.eclipse.ditto.model.thingsearch.ImmutableSortOption;
import org.eclipse.ditto.model.thingsearch.ImmutableSortOptionEntry;
import org.eclipse.ditto.model.thingsearch.LimitOption;
import org.eclipse.ditto.model.thingsearch.Option;
import org.eclipse.ditto.model.thingsearch.SearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchQuery;
import org.eclipse.ditto.model.thingsearch.SearchQueryBuilder;
import org.eclipse.ditto.model.thingsearch.SortOption;
import org.eclipse.ditto.model.thingsearch.SortOptionEntry;

@NotThreadSafe
final class ImmutableSearchQueryBuilder
implements SearchQueryBuilder {
    private final SearchFilter searchFilter;
    private final Map<JsonPointer, SortOptionEntry> sortOptionEntries;
    private LimitOption limitOption;

    private ImmutableSearchQueryBuilder(SearchFilter theSearchFilter) {
        this.searchFilter = theSearchFilter;
        this.sortOptionEntries = new LinkedHashMap<JsonPointer, SortOptionEntry>();
        this.limitOption = null;
    }

    public static ImmutableSearchQueryBuilder of(SearchFilter searchFilter) {
        return new ImmutableSearchQueryBuilder((SearchFilter)ConditionChecker.checkNotNull((Object)searchFilter, (String)"search filter"));
    }

    @Override
    public SearchQueryBuilder sortAsc(CharSequence propertyPath) {
        this.putEntry(propertyPath, ImmutableSortOptionEntry::asc);
        return this;
    }

    private void putEntry(CharSequence path, Function<JsonPointer, SortOptionEntry> createEntryFunction) {
        JsonPointer jsonPointer = JsonFactory.newPointer((CharSequence)path);
        this.sortOptionEntries.put(jsonPointer, createEntryFunction.apply(jsonPointer));
    }

    @Override
    public SearchQueryBuilder sortDesc(CharSequence propertyPath) {
        this.putEntry(propertyPath, ImmutableSortOptionEntry::desc);
        return this;
    }

    @Override
    public SearchQueryBuilder removeSortOptionFor(CharSequence propertyPath) {
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"path of the property to remove the sort option for");
        this.sortOptionEntries.remove(JsonFactory.newPointer((CharSequence)propertyPath));
        return this;
    }

    @Override
    public SearchQueryBuilder limit(int offset, int count) {
        ConditionChecker.checkArgument((Object)offset, o -> o >= 0, () -> "The offset must not be negative!");
        ConditionChecker.checkArgument((Object)count, c -> c > 0, () -> "The count must neither be negative nor zero!");
        ConditionChecker.checkArgument((Object)count, c -> c <= 200, () -> "The count must not be greater than 200!");
        this.limitOption = ImmutableLimitOption.of(offset, count);
        return this;
    }

    @Override
    public SearchQueryBuilder removeLimitation() {
        this.limitOption = null;
        return this;
    }

    @Override
    public SearchQuery build() {
        return new ImmutableSearchQuery(this);
    }

    @Immutable
    private static final class ImmutableSearchQuery
    implements SearchQuery {
        private final SearchFilter filter;
        private final SortOption sortOption;
        private final LimitOption limitOption;

        private ImmutableSearchQuery(ImmutableSearchQueryBuilder builder) {
            this.filter = builder.searchFilter;
            ArrayList<SortOptionEntry> sortOptionEntries = new ArrayList<SortOptionEntry>(builder.sortOptionEntries.values());
            this.sortOption = !sortOptionEntries.isEmpty() ? ImmutableSortOption.of(sortOptionEntries) : null;
            this.limitOption = builder.limitOption;
        }

        @Override
        public SearchFilter getFilter() {
            return this.filter;
        }

        @Override
        public Optional<SortOption> getSortOption() {
            return Optional.ofNullable(this.sortOption);
        }

        @Override
        public Optional<LimitOption> getLimitOption() {
            return Optional.ofNullable(this.limitOption);
        }

        @Override
        public Collection<Option> getAllOptions() {
            ArrayList<Option> result = new ArrayList<Option>(2);
            result.add(this.sortOption);
            this.getLimitOption().ifPresent(result::add);
            return result;
        }

        @Override
        public String getFilterAsString() {
            return this.filter.toString();
        }

        @Override
        public String getOptionsAsString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.getLimitOption().map(Option::toString).ifPresent(stringBuilder::append);
            this.getSortOption().map(Option::toString).ifPresent(sortOptionString -> {
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append((String)sortOptionString);
            });
            return stringBuilder.toString();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [filter=" + this.filter + ", sortOption=" + this.sortOption + ", limitOption=" + this.limitOption + "]";
        }
    }
}

