/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.thingsearch.LogicalSearchFilter;
import org.eclipse.ditto.model.thingsearch.SearchFilter;

@Immutable
final class ImmutableLogicalFilter
implements LogicalSearchFilter {
    private final SearchFilter.Type type;
    private final Collection<SearchFilter> searchFilters;

    private ImmutableLogicalFilter(SearchFilter.Type theFilterType, Collection<SearchFilter> theFilters) {
        this.type = theFilterType;
        this.searchFilters = Collections.unmodifiableList(new ArrayList<SearchFilter>(theFilters));
    }

    public static ImmutableLogicalFilter not(SearchFilter filter) {
        ConditionChecker.checkNotNull((Object)filter, (String)"filter to be negated");
        return new ImmutableLogicalFilter(SearchFilter.Type.NOT, Collections.singleton(filter));
    }

    public static ImmutableLogicalFilter and(SearchFilter filter1, SearchFilter filter2, SearchFilter ... furtherFilters) {
        ConditionChecker.checkNotNull((Object)filter1, (String)"first filter to be concatenated with AND");
        ConditionChecker.checkNotNull((Object)filter2, (String)"second filter to be concatenated with AND");
        ConditionChecker.checkNotNull((Object)furtherFilters, (String)"further searchFilters to be concatenated with AND");
        return new ImmutableLogicalFilter(SearchFilter.Type.AND, ImmutableLogicalFilter.paramsToList(filter1, filter2, furtherFilters));
    }

    public static ImmutableLogicalFilter or(SearchFilter filter1, SearchFilter filter2, SearchFilter ... furtherFilters) {
        ConditionChecker.checkNotNull((Object)filter1, (String)"first filter to be concatenated with OR");
        ConditionChecker.checkNotNull((Object)filter2, (String)"second filter to be concatenated with OR");
        ConditionChecker.checkNotNull((Object)furtherFilters, (String)"further searchFilters to be concatenated with OR");
        return new ImmutableLogicalFilter(SearchFilter.Type.OR, ImmutableLogicalFilter.paramsToList(filter1, filter2, furtherFilters));
    }

    @SafeVarargs
    private static <T> List<T> paramsToList(T param1, T param2, T ... furtherParams) {
        ArrayList<T> result = new ArrayList<T>(2 + furtherParams.length);
        result.add(param1);
        result.add(param2);
        Collections.addAll(result, furtherParams);
        return result;
    }

    @Override
    public SearchFilter.Type getType() {
        return this.type;
    }

    @Override
    public Collection<SearchFilter> getFilters() {
        return this.searchFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLogicalFilter that = (ImmutableLogicalFilter)o;
        return this.type == that.type && Objects.equals(this.searchFilters, that.searchFilters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.searchFilters});
    }

    @Override
    public String toString() {
        return this.createFilterString();
    }

    private String createFilterString() {
        String delimiter = ",";
        String prefix = this.type.getName() + "(";
        String suffix = ")";
        return this.searchFilters.stream().map(SearchFilter::toString).collect(Collectors.joining(",", prefix, ")"));
    }
}

