/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.thingsearch;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.thingsearch.CursorOption;
import org.eclipse.ditto.model.thingsearch.OptionVisitor;

@Immutable
final class ImmutableCursorOption
implements CursorOption {
    private final String cursor;

    private ImmutableCursorOption(String cursor) {
        this.cursor = cursor;
    }

    static ImmutableCursorOption of(String size) {
        return new ImmutableCursorOption(size);
    }

    @Override
    public void accept(OptionVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableCursorOption) {
            ImmutableCursorOption that = (ImmutableCursorOption)o;
            return Objects.equals(this.cursor, that.cursor);
        }
        return false;
    }

    @Override
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.cursor);
    }

    @Override
    public String toString() {
        return "cursor(" + this.cursor + ")";
    }
}

