/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.CredentialsVisitor;

@Immutable
public final class UserPasswordCredentials
implements Credentials {
    public static final String TYPE = "plain";
    private final String username;
    private final String password;

    private UserPasswordCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public <T> T accept(CredentialsVisitor<T> visitor) {
        return visitor.usernamePassword(this);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPasswordCredentials that = (UserPasswordCredentials)o;
        return this.username.equals(that.username) && this.password.equals(that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [username=" + this.username + ", password=" + this.password + "]";
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(JsonFields.TYPE, (Object)TYPE);
        jsonObjectBuilder.set(JsonFields.USERNAME, (Object)this.username);
        jsonObjectBuilder.set(JsonFields.PASSWORD, (Object)this.password);
        return jsonObjectBuilder.build();
    }

    static UserPasswordCredentials fromJson(JsonObject jsonObject) {
        String username = (String)jsonObject.getValueOrThrow(JsonFields.USERNAME);
        String password = (String)jsonObject.getValueOrThrow(JsonFields.PASSWORD);
        return new UserPasswordCredentials(username, password);
    }

    public static UserPasswordCredentials newInstance(String username, String password) {
        return new UserPasswordCredentials(username, password);
    }

    public static final class JsonFields
    extends Credentials.JsonFields {
        public static final JsonFieldDefinition<String> USERNAME = JsonFieldDefinition.ofString((CharSequence)"username", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> PASSWORD = JsonFieldDefinition.ofString((CharSequence)"password", (JsonFieldMarker[])new JsonFieldMarker[0]);
    }
}

