/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:topic.invalid")
@Immutable
public final class TopicParseException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:topic.invalid";
    private static final String MESSAGE_TEMPLATE = "The topic ''{0}'' could not be parsed.";
    private static final String DEFAULT_DESCRIPTION = "Check if the format is the expected one.";
    private static final String DESCRIPTION_WITH_HINT = "''{0}'' - check if the format is the expected one.";
    private static final long serialVersionUID = -2896189723489733822L;

    private TopicParseException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String parsedFilterString) {
        return new Builder(parsedFilterString, null);
    }

    public static Builder newBuilder(String parsedFilterString, @Nullable String descriptionHint) {
        return new Builder(parsedFilterString, descriptionHint);
    }

    public static TopicParseException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (TopicParseException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static TopicParseException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (TopicParseException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<TopicParseException> {
        private Builder() {
            this.description(TopicParseException.DEFAULT_DESCRIPTION);
        }

        private Builder(String parsedFilterString, @Nullable String descriptionHint) {
            this();
            if (descriptionHint != null) {
                this.description(MessageFormat.format(TopicParseException.DESCRIPTION_WITH_HINT, descriptionHint));
            }
            this.message(MessageFormat.format(TopicParseException.MESSAGE_TEMPLATE, parsedFilterString));
        }

        protected TopicParseException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new TopicParseException(dittoHeaders, message, description, cause, href);
        }
    }
}

