/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public enum Topic {
    TWIN_EVENTS("_/_/things/twin/events", "things.events:"),
    LIVE_MESSAGES("_/_/things/live/messages", "messages.commands:"),
    LIVE_EVENTS("_/_/things/live/events", "things-live-events"),
    LIVE_COMMANDS("_/_/things/live/commands", "things-live-commands"),
    POLICY_ANNOUNCEMENTS("_/_/policies/announcements", "policy-announcements");

    private final String name;
    private final String pubSubTopic;

    private Topic(String name, String pubSubTopic) {
        this.pubSubTopic = pubSubTopic;
        this.name = name;
    }

    public String getPubSubTopic() {
        return this.pubSubTopic;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<Topic> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(Topic.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    public String toString() {
        return this.name;
    }
}

